% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dont_sleep.R
\name{dont_sleep}
\alias{dont_sleep}
\alias{dont_sleep_time}
\title{Prevent Computer from Sleeping by Simulating Mouse Activity}
\usage{
dont_sleep(sec_range = c(20, 60), off_time = 18.5, quiet = FALSE)

dont_sleep_time(quiet = FALSE)
}
\arguments{
\item{sec_range}{Numeric vector of length 2. Range (in seconds) of
random intervals between mouse movements and clicks. Default is \code{c(20, 60)}.}

\item{off_time}{Numeric. Decimal hour (24h format) to stop the function
automatically, e.g. 18.5 means 18:30 (6:30 PM). Default is \code{18.5}.}

\item{quiet}{Logical. If \code{TRUE}, suppresses progress messages.
Default is \code{FALSE}.}
}
\value{
Invisibly returns \code{NULL} when the function exits.
}
\description{
Keeps the computer awake by moving the mouse cursor and clicking
periodically with a human-like behavior. It automatically detects
the operating system (Windows or macOS) and runs the appropriate
underlying logic.
}
\details{
The cursor initially moves to the upper-left corner (0,0), then
performs small random movements and clicks periodically to avoid
system sleep. The function exits if the user moves the mouse away
from the corner or when the specified off-time is reached.

Requires \code{cliclick} installed on macOS (install via Homebrew:
\code{brew install cliclick}), and the \code{KeyboardSimulator}
package on Windows.
}
\examples{
\dontrun{
# Keep the computer awake until 8:00 PM, with mouse actions every 30 to 60 seconds
dont_sleep(sec_range = c(30, 60), off_time = 20)
# Summary of amount of daily time running function
dont_sleep_time()
}
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{chr2num}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{files_functions}()},
\code{\link{font_exists}()},
\code{\link{formatColoured}()},
\code{\link{formatHTML}()},
\code{\link{glued}()},
\code{\link{grepm}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{list_cats}()},
\code{\link{listfiles}()},
\code{\link{mail_send}()},
\code{\link{markdown2df}()},
\code{\link{move_files}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{warnifnot}()},
\code{\link{what_size}()}
}
\concept{Tools}
