% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{as.data.frame.lcModels}
\alias{as.data.frame.lcModels}
\title{Generate a data.frame containing the argument values per method per row}
\usage{
\method{as.data.frame}{lcModels}(x, ..., excludeShared = FALSE, eval = TRUE)
}
\arguments{
\item{x}{\code{lcModels} or a list of \code{lcModel}}

\item{...}{Arguments passed to \link{as.data.frame.lcMethod}.}

\item{excludeShared}{Whether to exclude columns which have the same value across all methods.}

\item{eval}{Whether to evaluate the arguments in order to replace expression if the resulting value is of a class specified in \code{evalClasses}.}
}
\value{
A \code{data.frame}.
}
\description{
Generate a data.frame containing the argument values per method per row
}
\section{Functionality}{

\itemize{
\item \link[=print.lcModels]{Print} an argument summary for each of the models.
\item \link[=as.data.frame.lcModels]{Convert} to a \code{data.frame} of method arguments.
\item \link[=subset.lcModels]{Subset} the list.
\item Compute an \link[=metric]{internal metric} or \link[=externalMetric]{external metric}.
\item Obtain the best model according to \link[=min.lcModels]{minimizing} or \link[=max.lcModels]{maximizing} a \link[=latrend-metrics]{metric}.
\item Obtain the summed \link[=estimationTime]{estimation time}.
\item \link[=plotMetric]{Plot a metric} across a variable.
\item \link[=plotClusterTrajectories]{Plot the cluster trajectories}.
}
}

