% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/model.R
\name{clusterProportions}
\alias{clusterProportions}
\alias{clusterProportions,lcModel-method}
\title{Proportional size of each cluster}
\usage{
clusterProportions(object, ...)

\S4method{clusterProportions}{lcModel}(object, ...)
}
\arguments{
\item{object}{The model.}

\item{...}{For \code{lcModel} objects: Additional arguments passed to \code{\link[=postprob]{postprob()}}.}
}
\value{
A \verb{named numeric vector} of length \code{nClusters(object)} with the proportional size of each cluster.
}
\description{
Obtain the proportional size per cluster, between 0 and 1.
}
\section{lcModel}{

By default, the cluster proportions are determined from the cluster-averaged posterior probabilities of the fitted data (as computed by the \code{\link[=postprob]{postprob()}} function).

Classes extending \code{lcModel} can override this method to return, for example, the exact estimated mixture proportions based on the model coefficients.
\preformatted{
setMethod("clusterProportions", "lcModelExt", function(object, ...) {
  # return cluster proportion vector
})
}
}

\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData, nClusters = 2)
clusterProportions(model)
}
\seealso{
\link{nClusters} \link{clusterNames}

\link{clusterSizes} \link{postprob}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
