% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipletesting.R
\name{closed_testing}
\alias{closed_testing}
\alias{alpha_zmax}
\title{Closed testing procedure}
\usage{
closed_testing(object, test = test_wald, ...)
}
\arguments{
\item{object}{`estimate` object}

\item{test}{function that conducts hypothesis test. See details below.}

\item{...}{Additional arguments passed to `test`}
}
\description{
Given p hypotheses H1, ..., Hp all 2^p-1 intersection hypotheses are
calculated and adjusted p-values are obtained for Hj is calculated as the
max p-value of all intersection hypotheses containing Hj. Example, for p=3,
the adjusted p-value for H1 will be obtained from \{(H1, H2, H3), (H1,H2),
(H1,H3), (H1)\}.
}
\details{
The function `test` should be a function `function(object, index,
  ...)` which as its first argument takes an `estimate` object and and wit
  an argument `index` which is a integer vector specifying which
  subcomponents of `object` to test. The ellipsis argument can be any other
  arguments used in the test function. The function \code{test_wald} is an
  example of valid test function (which has an additional argument `null` in
  reference to the above mentioned ellipsis arguments).
}
\examples{
m <- lvm()
regression(m, c(y1,y2,y3,y4)~x) <- c(0, 0.25, 0, 0.25)
regression(m, to=endogenous(m), from="u") <- 1
variance(m,endogenous(m)) <- 1
set.seed(1)
d <- sim(m, 200)
l1 <- lm(y1~x,d)
l2 <- lm(y2~x,d)
l3 <- lm(y3~x,d)
l4 <- lm(y4~x,d)

(a <- merge(l1, l2, l3, l4, subset=2))
if (requireNamespace("mets",quietly=TRUE)) {
   alpha_zmax(a)
}
adj <- closed_testing(a)
adj
adj$p.value
summary(adj)
}
\references{
Marcus, R; Peritz, E; Gabriel, KR (1976).
  "On closed testing procedures with special reference to ordered analysis
  of variance". Biometrika. 63 (3): 655–660.
}
