% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool-estimates.R
\name{parameterEstimates.mi}
\alias{parameterEstimates.mi}
\alias{parameterestimates.mi}
\title{Pooled Parameter Estimates}
\usage{
parameterEstimates.mi(
  object,
  se = TRUE,
  zstat = se,
  pvalue = zstat,
  ci = TRUE,
  level = 0.95,
  fmi = FALSE,
  standardized = FALSE,
  cov.std = TRUE,
  rsquare = FALSE,
  asymptotic = FALSE,
  scale.W = !asymptotic,
  omit.imps = c("no.conv", "no.se"),
  remove.system.eq = TRUE,
  remove.eq = TRUE,
  remove.ineq = TRUE,
  remove.def = FALSE,
  remove.nonfree = FALSE,
  remove.unused = FALSE,
  output = "data.frame",
  header = FALSE
)
}
\arguments{
\item{object}{An object of class \code{lavaan.mi}}

\item{se, zstat, pvalue, ci, level, standardized, cov.std, rsquare, remove.system.eq, remove.eq, remove.ineq, remove.def, remove.nonfree, remove.unused, output, header}{See \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}.}

\item{fmi}{\code{logical} indicating whether to add 2 columns:
\itemize{
\item the fraction of missing information (\verb{$fmi}), which is the ratio of
between-imputation variance to total (pooled) sampling variance
\item the relative increase in variance (\verb{$riv}), which is the ratio of
between-imputation variance to within-imputation variance
}

Thus, RIV = FMI / (1 \eqn{-} FMI) and FMI = RIV / (1 + RIV).
Ignored when \code{se=FALSE}.}

\item{asymptotic}{\code{logical}. When \code{FALSE}, pooled Wald tests will be \emph{t}
statistics with associated degrees of freedom (\emph{df}). When \code{TRUE},
the \emph{df} are assumed to be sufficiently large for a \emph{t} statistic to
approximate a standard normal distribution, so it is printed as a \emph{z}
statistic.}

\item{scale.W}{\code{logical}. If \code{TRUE} (default), the \code{vcov}
method will calculate the pooled covariance matrix by scaling the
within-imputation component by the ARIV (see Enders, 2010, p. 235,
for definition and formula). Otherwise, the pooled matrix is
calculated as the weighted sum of the within-imputation and
between-imputation components (see Enders, 2010, ch. 8, for details).}

\item{omit.imps}{\code{character} indicating criteria for excluding imputations
from pooled results. See \linkS4class{lavaan.mi} for argument details.}
}
\value{
A \code{data.frame}, analogous to \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}, but estimates,
\emph{SE}s, and tests are pooled across imputations.
}
\description{
This function pools parameter estimates from a lavaan model fitted to
multiple imputed data sets.
}
\examples{

data(HS20imps) # import a list of 20 imputed data sets

## specify CFA model from lavaan's ?cfa help page
HS.model <- '
  visual  =~ x1 + x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
'
## fit model to 20 imputed data sets
fit <- cfa.mi(HS.model, data = HS20imps)

## pooled estimates, with various optional features:

parameterEstimates.mi(fit, asymptotic = TRUE, rsquare = TRUE)
parameterEstimates.mi(fit, ci = FALSE, fmi = TRUE, output = "text")
parameterEstimates.mi(fit, standardized = "std.all", se = FALSE)

}
\references{
Enders, C. K. (2010). \emph{Applied missing data analysis}. New York, NY:
Guilford.

Rubin, D. B. (1987). \emph{Multiple imputation for nonresponse in surveys}.
New York, NY: Wiley. \doi{10.1002/9780470316696}
}
\seealso{
\code{\link[=standardizedSolution.mi]{standardizedSolution.mi()}} to obtain inferential statistics for pooled
standardized parameter estimates.
}
\author{
Terrence D. Jorgensen (University of Amsterdam;
\email{TJorgensen314@gmail.com})
}
