% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterEstimates_table_list.R,
%   R/print_parameterEstimates_table_list.R
\name{parameterEstimates_table_list}
\alias{parameterEstimates_table_list}
\alias{print_parameterEstimates_table_list}
\title{Convert an Estimates Table to
a List of Data Frames}
\usage{
parameterEstimates_table_list(
  object,
  ...,
  fit_object = NULL,
  se_also_to_na = character(0),
  se_not_to_na = character(0),
  drop_cols = "std.nox",
  rename_cols = character(0),
  est_funs = list(),
  header_funs = list(),
  footer_funs = list(),
  est_funs_args = NULL,
  header_funs_args = NULL,
  footer_funs_args = NULL
)

print_parameterEstimates_table_list(
  x,
  nd = 3,
  by_group = TRUE,
  drop_cols = character(0),
  na_str = " "
)
}
\arguments{
\item{object}{It can a data frame
similar in form to the output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}, or a
\code{lavaan} object (e.g., the output of
\code{\link[lavaan:sem]{lavaan::sem()}}). If it is a \code{lavaan}
object, then
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} will
be called to generate the parameter
estimates table.}

\item{...}{If \code{object} is a \code{lavaan}
object, then these are the optional
arguments to be passed to
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} when
it is called.}

\item{fit_object}{(Optional). The
\code{lavaan} object for getting
additional information, if they are
not available in \code{object}, and added
as attributes to \code{object}. It
essentially does what
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} does
when setting \code{output} to \code{"text"}.}

\item{se_also_to_na}{Columns for
which cells will be set to \code{NA} if
the standard error of a parameter is
zero, which is assumed to mean that
this parameter is fixed. By default,
these columns are included and no
need to specify them for this
argument: \code{"z"}, \code{"pvalue"}, \code{"t"},
\code{"df"}, \code{"ci.lower"}, and
\code{"ci.upper"}. To exclude one of these
columns from \code{se_als_to_na}, add it
to \code{se_not_to_na}.}

\item{se_not_to_na}{Columns for which
cells will \emph{not} be set to \code{NA} even if
the standard error of a parameter is
zero. Column names that appear here
\emph{override} \code{se_also_to_na}.
Therefore, if \code{"z"}, \code{"pvalue"},
\code{"t"}, \code{"df"}, \code{"ci.lower"}, and
\code{"ci.upper"} are included in this
argument, they will also not be set
to \code{NA}.}

\item{drop_cols}{The names of columns
to be dropped from the printout. It
can be the names after being renamed
by \code{rename_cols}, or the original
names before being renamed (i.e., the
names in \code{object}), provided that the
names in \code{object} are stored in the
attribute \code{"original_name"} of each
column, which is done by default by
\code{\link[=parameterEstimates_table_list]{parameterEstimates_table_list()}}.}

\item{rename_cols}{If any columns are
to be renamed, this is named
character vector, with the names
being the original names and the
values being the new names. For
example, \code{c("pvalue" = "P(|>z|)")}
renames the column \code{"pvalue"} to
\code{"P(|z|)"}. It is recommended to
quote the names too because they may
not be standard names.}

\item{est_funs}{If supplied, it
should be a list of functions to be
applied to each parameter estimates
table, applied in the same order they
appear in the list. It can be used
create new columns or modify existing
columns. Usually, this should be done
\emph{before} calling
\code{\link[=parameterEstimates_table_list]{parameterEstimates_table_list()}} but
provided as an option.}

\item{header_funs}{If supplied, it
should be a list of functions to be
applied to \code{object} to generate the
header sections. See \code{Details} on the
expected format of the output of
these functions.}

\item{footer_funs}{If supplied, it
should be a list of functions to be
applied to \code{object} to generate the
footer sections. See \code{Details} on the
expected format of the output of
these functions.}

\item{est_funs_args}{If supplied, it
must be a "list of list(s)". The length
of this list must be equal to the
number of functions in \code{est_funs}.
Each sub-list is the list of arguments
to be used when calling a function in
\code{est_funs}. It must be an empty
\code{list()} if no additional arguments
are to be used when calling a function
in \code{est_funs}.}

\item{header_funs_args}{If supplied, it
must be a "list of list(s)". The length
of this list must be equal to the
number of functions in \code{header_funs}.
Each sub-list is the list of arguments
to be used when calling a function in
\code{header_funs}. It must be an empty
\code{list()} if no additional arguments
are to be used when calling a function
in \code{header_funs}.}

\item{footer_funs_args}{If supplied, it
must be a "list of list(s)". The length
of this list must be equal to the
number of functions in \code{footer_funs}.
Each sub-list is the list of arguments
to be used when calling a function in
\code{footer_funs}. It must be an empty
\code{list()} if no additional arguments
are to be used when calling a function
in \code{footer_funs}.}

\item{x}{The object to be printed.
Should be the output of
\code{\link[=parameterEstimates_table_list]{parameterEstimates_table_list()}}.}

\item{nd}{The number of decimal
places to be displayed for numeric
cells.}

\item{by_group}{If \code{TRUE}, the
default, tables will be grouped by
groups first, and then by grouped by
sections (e.g., \verb{Latent Variables},
\code{Regressions}, etc.). If \code{FALSE},
then the tables will be grouped by
sections first, and then grouped by
groups. No effect if the number of
groups is equal to one.}

\item{na_str}{The string to be used
for cells with \code{NA}. Default is
\code{" "}, a white space.}
}
\value{
\subsection{\code{\link[=parameterEstimates_table_list]{parameterEstimates_table_list()}}}{

A list of data frames of the
class \code{parameterEstimates_table_list},
with this
structure.
\itemize{
\item \code{group}: A list of data frames for
each group. It is a list of length
equal to one if the model has only
one group. For each group, the
content is a list of data frames,
one for each section of the estimates.
\item \code{model}: A list of tables for
sections such as user-defined
parameters (\code{"Defined Parameters"})
or model constraints (\code{"Constraints"}).
\item \code{header}: A list of header sections.
\item \code{footer}: A list of footer sections.
}

The decision of not having a \code{print}
method is intentional. It is intended
to be used by other
the \code{print} methods of other classes,
to create the formatted list of
tables,
and then print it by calling
\code{\link[=print_parameterEstimates_table_list]{print_parameterEstimates_table_list()}}
internally.
}

\subsection{\code{\link[=print_parameterEstimates_table_list]{print_parameterEstimates_table_list()}}}{

The original input, \code{x}, is returned
invisibly. Called for its side
effect to print the content of
\code{x}.
}
}
\description{
Create a list of data
frames from the output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}},
formatted in nearly the same way the
argument \code{output = "text"} does.
}
\details{
This function creates an
output mimicking the output format
when \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}
is called with \code{output} set to
\code{"text"}. It only creates the output
as a list of data frames, grouped in
sections like \verb{Latent Variables} and
\code{Regression}, as in the printout of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}. It
does not format the content. The
actual printing is to be done by
\code{\link[=print_parameterEstimates_table_list]{print_parameterEstimates_table_list()}},
which will format the cells before
printing them.

This function is not intended to be
used by end-users. It is intended
to be used inside other functions,
such as a print method. Functions
that add columns to the parameter
estimates table of a \code{lavaan} object
can use it and
\link[=print_parameterEstimates_table_list]{PRINT_parameterEstimates_table_list()}
to print the output in the
\code{lavaan}-style, but with columns
modified as needed and with additional
header and/or footer sections added.

Therefore, it was developed with
flexibility in mind, at the expense
of user-friendliness.
\subsection{Header and Footer Functions}{

If a list of functions
is supplied to \code{header_funs} or
\code{footer_funs}, they will be used
to generate the headers and/or
footers. The first argument of these
function will be one of the followings.

If \code{object} is a data frame like
object, then the first argument is
this object when calling thews functions.

If \code{object} is a \code{lavaan} object,
then the first argument is the
parameter estimates table generated
by \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}
with \verb{output = "text", header = TRUE}.

The output of these functions
should be one of the following
formats.

It can be a data frame with two
optional attributes: \code{section_title}
and \code{print_args}. If \code{section_title}
is not null, it will be printed by
\code{\link[=cat]{cat()}} before printing tbe section.
The header or
footer section will then be printed by
\code{\link[=print]{print()}}. If \code{print_args} is set
to be a list of named arguments, then
they will be used when calling
\code{\link[=print]{print()}}. For example, setting
\code{print_args} to
\code{list(right = FALSE, row.names = FALSE)}
will print the data frame with these
arguments.

It can also be any other object that
can be printed. One possible case is
a character vector of footnotes. In
this case, we can add this
attribute \code{print_fun} and set it to
\code{"cat"}, the name of the function
to be used to print the section,
and add the attribute \code{print_args}
and set it to be a named list of
arguments to be passed to \code{print_fun}.

Special treatment when \code{print-fun}
is "cat"`:
\itemize{
\item The default of \code{sep}
is \code{"\\n"}. To override this default,
set the attribute \code{print_args} and
set \code{sep} to something else.
\item Each element in the object, which
should be a character vector, is
processed by \code{\link[=strwrap]{strwrap()}} by default.
Additional arguments to \code{\link[=strwrap]{strwrap()}}
can be passed by setting the attribute
\code{strwrap_args} to a named list of
the arguments for \code{\link[=strwrap]{strwrap()}} (e.g.,
\code{list(exdent = 2)}). To disable
this feature, set the attribute
\code{wrap_lines} to \code{FALSE}.
}

These arguments \code{header_funs}
and \code{footer_args} allow users to
add header and footer sections and
print them in the desired format.
}
}
\section{Limitations}{
These function do not yet support
multilevel models.
}

\examples{

# Adapted from the help of lavaan::cfa()
library(lavaan)
mod <- "
visual  =~ x1 + x2 + x3
textual =~ x4 + x5 + x6
speed   =~ x7 + x8 + x9
"
fit <- cfa(mod,
           data = HolzingerSwineford1939)
est <- parameterEstimates_table_list(fit,
                                     rename_cols = c("P(>|z|)" = "pvalue",
                                                     "S.E." = "SE"))
print_parameterEstimates_table_list(est,
                                    drop = "Z")
fit2 <- cfa(mod,
            data = HolzingerSwineford1939,
            group = "school")
est2 <- parameterEstimates_table_list(fit2)
# The tables in the same group are printed together (default)
print_parameterEstimates_table_list(est2,
                                    by_group = TRUE)
# The table are grouped by section then by group
print_parameterEstimates_table_list(est2,
                                    by_group = FALSE)

# A simple function to add "***" for parameters with p-values < .001
add_sig <- function(object,
                    pvalue = "pvalue") {
    tmp <- object[, pvalue, drop = TRUE]
    if (!is.null(tmp)) {
        tmp[is.na(tmp)] <- 1
        tmp2 <- ifelse(tmp < .001, "***", "")
        i <- match(pvalue, colnames(object))
        out <- data.frame(object[, 1:i],
                          Sig = tmp2,
                          object[, seq(i + 1, ncol(object))])
      }
    out
  }

est3 <- parameterEstimates_table_list(fit2,
                                      est_funs = list(add_sig))
print_parameterEstimates_table_list(est3)

}
\seealso{
\code{\link[=print_parameterEstimates_table_list]{print_parameterEstimates_table_list()}}
for the printing function, and
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} for
generating the parameter estimates
table.
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
