% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_between.R
\name{date_between}
\alias{date_between}
\title{Create SQL string to select date between two given dates}
\usage{
date_between(column_name, date_range)
}
\arguments{
\item{column_name}{[character(1)]\cr
Name of data base column to select dates from.}

\item{date_range}{[Date(1:2)]\cr
One or two dates giving the date range in which the dates should be enclosed (closed interval).
If only one date is given, it is taken for both upper and lower limits.}
}
\value{
Character string to be used in SQL statement.
}
\description{
Create string with SQL \code{BETWEEN} expression for \code{WHERE} clause to select dates
 within the given range.
}
\details{
\code{column_name} must be a valid SQL identifier. It is validated to conform to
 the regular expression returned by \code{\link{valid_identifier_regex}}.
}
\examples{
date1 <- as.Date("2016-02-22")
date2 <- as.Date("2016-02-11")

# SQL expression for a date range
(sql_expr1 <- lazysql::date_between("STD_1", c(date1, date2)))

# SQL expression for a single date
(sql_expr2 <- lazysql::date_between("STD_1", date1))

# sample SQL statements
paste("select * from TEST_TABLE where", sql_expr1)

paste("select * from TEST_TABLE where", sql_expr2)

}
\author{
Uwe Block
}
\seealso{
\code{\link{valid_identifier_regex}}.
}

