% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geosearch.R
\name{addGeosearch}
\alias{addGeosearch}
\title{Add a GeoSearch control to a Leaflet map}
\usage{
addGeosearch(map, provider = geosearchProvider(), options = geosearchOptions())
}
\arguments{
\item{map}{a map widget}

\item{provider}{A provider list object created with e.g. `geosearchProviderOSM()`.}

\item{options}{A list of control options created with `geosearchOptions()`.}
}
\value{
the new \code{map} object
}
\description{
Adds a geocoding search widget to a leaflet map using the leaflet-geosearch plugin.
Supports multiple providers such as OpenStreetMap, Esri, Google, HERE, etc.
}
\examples{
library(leaflet)
library(leaflet.extras2)

leaflet() \%>\%
  addTiles() \%>\%
  addGeosearch()
}
\references{
\url{https://github.com/smeijer/leaflet-geosearch}
}
\seealso{
Other Geosearch Functions: 
\code{\link{geosearchOptions}()},
\code{\link{removeGeosearch}()}
}
\concept{Geosearch Functions}
