% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omnivore.R
\name{addGeoJSONv2}
\alias{addGeoJSONv2}
\alias{legendOptions}
\alias{addGeoJSONChoropleth}
\alias{addKML}
\alias{addKMLChoropleth}
\alias{csvParserOptions}
\alias{addCSV}
\alias{addGPX}
\title{Adds a GeoJSON/TopoJSON to the leaflet map.}
\usage{
addGeoJSONv2(
  map,
  geojson,
  layerId = NULL,
  group = NULL,
  markerType = NULL,
  markerIcons = NULL,
  markerIconProperty = NULL,
  markerOptions = leaflet::markerOptions(),
  clusterOptions = NULL,
  clusterId = NULL,
  labelProperty = NULL,
  labelOptions = leaflet::labelOptions(),
  popupProperty = NULL,
  popupOptions = leaflet::popupOptions(),
  stroke = TRUE,
  color = "#03F",
  weight = 5,
  opacity = 0.5,
  fill = TRUE,
  fillColor = color,
  fillOpacity = 0.2,
  dashArray = NULL,
  smoothFactor = 1,
  noClip = FALSE,
  pathOptions = leaflet::pathOptions(),
  highlightOptions = NULL
)

legendOptions(
  title = NULL,
  position = c("bottomleft", "bottomright", "topleft", "topright"),
  locale = "en-US",
  numberFormatOptions = list(style = "decimal", maximumFractionDigits = 2)
)

addGeoJSONChoropleth(
  map,
  geojson,
  layerId = NULL,
  group = NULL,
  valueProperty,
  labelProperty = NULL,
  labelOptions = leaflet::labelOptions(),
  popupProperty = NULL,
  popupOptions = leaflet::popupOptions(),
  scale = c("white", "red"),
  steps = 5,
  mode = "q",
  channelMode = c("rgb", "lab", "hsl", "lch"),
  padding = NULL,
  correctLightness = FALSE,
  bezierInterpolate = FALSE,
  colors = NULL,
  stroke = TRUE,
  color = "#03F",
  weight = 1,
  opacity = 0.5,
  fillOpacity = 0.2,
  dashArray = NULL,
  smoothFactor = 1,
  noClip = FALSE,
  pathOptions = leaflet::pathOptions(),
  highlightOptions = NULL,
  legendOptions = NULL
)

addKML(
  map,
  kml,
  layerId = NULL,
  group = NULL,
  markerType = NULL,
  markerIcons = NULL,
  markerIconProperty = NULL,
  markerOptions = leaflet::markerOptions(),
  clusterOptions = NULL,
  clusterId = NULL,
  labelProperty = NULL,
  labelOptions = leaflet::labelOptions(),
  popupProperty = NULL,
  popupOptions = leaflet::popupOptions(),
  stroke = TRUE,
  color = "#03F",
  weight = 5,
  opacity = 0.5,
  fill = TRUE,
  fillColor = color,
  fillOpacity = 0.2,
  dashArray = NULL,
  smoothFactor = 1,
  noClip = FALSE,
  pathOptions = leaflet::pathOptions(),
  highlightOptions = NULL
)

addKMLChoropleth(
  map,
  kml,
  layerId = NULL,
  group = NULL,
  valueProperty,
  labelProperty = NULL,
  labelOptions = leaflet::labelOptions(),
  popupProperty = NULL,
  popupOptions = leaflet::popupOptions(),
  scale = c("white", "red"),
  steps = 5,
  mode = "q",
  channelMode = c("rgb", "lab", "hsl", "lch"),
  padding = NULL,
  correctLightness = FALSE,
  bezierInterpolate = FALSE,
  colors = NULL,
  stroke = TRUE,
  color = "#03F",
  weight = 1,
  opacity = 0.5,
  fillOpacity = 0.2,
  dashArray = NULL,
  smoothFactor = 1,
  noClip = FALSE,
  pathOptions = leaflet::pathOptions(),
  highlightOptions = NULL,
  legendOptions = NULL
)

csvParserOptions(latfield, lonfield, delimiter = ",")

addCSV(
  map,
  csv,
  csvParserOptions,
  layerId = NULL,
  group = NULL,
  markerType = NULL,
  markerIcons = NULL,
  markerIconProperty = NULL,
  markerOptions = leaflet::markerOptions(),
  clusterOptions = NULL,
  clusterId = NULL,
  labelProperty = NULL,
  labelOptions = leaflet::labelOptions(),
  popupProperty = NULL,
  popupOptions = leaflet::popupOptions(),
  stroke = TRUE,
  color = "#03F",
  weight = 5,
  opacity = 0.5,
  fill = TRUE,
  fillColor = color,
  fillOpacity = 0.2,
  dashArray = NULL,
  smoothFactor = 1,
  noClip = FALSE,
  pathOptions = leaflet::pathOptions(),
  highlightOptions = NULL
)

addGPX(
  map,
  gpx,
  layerId = NULL,
  group = NULL,
  markerType = NULL,
  markerIcons = NULL,
  markerIconProperty = NULL,
  markerOptions = leaflet::markerOptions(),
  clusterOptions = NULL,
  clusterId = NULL,
  labelProperty = NULL,
  labelOptions = leaflet::labelOptions(),
  popupProperty = NULL,
  popupOptions = leaflet::popupOptions(),
  stroke = TRUE,
  color = "#03F",
  weight = 5,
  opacity = 0.5,
  fill = TRUE,
  fillColor = color,
  fillOpacity = 0.2,
  dashArray = NULL,
  smoothFactor = 1,
  noClip = FALSE,
  pathOptions = leaflet::pathOptions(),
  highlightOptions = NULL
)
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}()}}

\item{geojson}{a GeoJSON/TopoJSON URL or file contents in a character vector.}

\item{layerId}{the layer id}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{markerType}{The type of marker. Either \code{marker} or \code{circleMarker}}

\item{markerIcons}{Icons for Marker.
Can be a single marker using \code{\link[leaflet]{makeIcon}}
or a list of markers using \code{\link[leaflet]{iconList}}}

\item{markerIconProperty}{The property of the feature to use for marker icon.
Can be a JS function which accepts a feature and returns an index of \code{markerIcons}.
In either case the result must be one of the indexes of markerIcons.}

\item{markerOptions}{The options for markers}

\item{clusterOptions}{if not \code{NULL}, markers will be clustered using
\href{https://github.com/Leaflet/Leaflet.markercluster}{Leaflet.markercluster};
 you can use \code{\link[leaflet]{markerClusterOptions}()} to specify marker cluster
options}

\item{clusterId}{the id for the marker cluster layer}

\item{labelProperty}{The property to use for the label.
You can also pass in a JS function that takes in a feature and returns a text/HTML content.}

\item{labelOptions}{A Vector of \code{\link[leaflet]{labelOptions}} to provide label
options for each label. Default \code{NULL}}

\item{popupProperty}{The property to use for popup content
You can also pass in a JS function that takes in a feature and returns a text/HTML content.}

\item{popupOptions}{A Vector of \code{\link[leaflet]{popupOptions}} to provide popups}

\item{stroke}{whether to draw stroke along the path (e.g. the borders of
polygons or circles)}

\item{color}{stroke color}

\item{weight}{stroke width in pixels}

\item{opacity}{stroke opacity (or layer opacity for tile layers)}

\item{fill}{whether to fill the path with color (e.g. filling on polygons or
circles)}

\item{fillColor}{fill color}

\item{fillOpacity}{fill opacity}

\item{dashArray}{a string that defines the stroke
\href{https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray}{dash
pattern}}

\item{smoothFactor}{how much to simplify the polyline on each zoom level
(more means better performance and less accurate representation)}

\item{noClip}{whether to disable polyline clipping}

\item{pathOptions}{Options for shapes}

\item{highlightOptions}{Options for highlighting the shape on mouse over.}

\item{title}{An optional title for the legend}

\item{position}{legend position}

\item{locale}{The numbers will be formatted using this locale}

\item{numberFormatOptions}{Options for formatting numbers}

\item{valueProperty}{The property to use for coloring}

\item{scale}{The scale to use from chroma.js}

\item{steps}{number of breakes}

\item{mode}{q for quantile, e for equidistant, k for k-means}

\item{channelMode}{Default "rgb", can be one of "rgb", "lab", "hsl", "lch"}

\item{padding}{either a single number or a 2 number vector for clipping color values at ends.}

\item{correctLightness}{whether to correct lightness}

\item{bezierInterpolate}{whether to use bezier interpolate for determining colors}

\item{colors}{overrides scale with manual colors}

\item{legendOptions}{Options to show a legend.}

\item{kml}{a KML URL or contents in a character vector.}

\item{latfield}{field name for latitude}

\item{lonfield}{field name for longitude}

\item{delimiter}{field separator}

\item{csv}{a CSV URL or contents in a character vector.}

\item{csvParserOptions}{options for parsing the CSV.
Use \code{\link{csvParserOptions}}() to supply csv parser options.}

\item{gpx}{a GPX URL or contents in a character vector.}
}
\description{
This is a feature rich alternative to the \code{\link[leaflet]{addGeoJSON}} & \code{\link[leaflet]{addTopoJSON}}
with options to map feature properties to labels, popups, colors, markers etc.
}
\examples{
## addGeoJSONv2
\donttest{
geoJson <- readr::read_file(
  "https://rawgit.com/benbalter/dc-maps/master/maps/historic-landmarks-points.geojson"
)

leaflet() \%>\%
  setView(-77.0369, 38.9072, 12) \%>\%
  addProviderTiles(providers$CartoDB.Positron) \%>\%
  addWebGLGeoJSONHeatmap(
    geoJson,
    size = 30, units = "px"
  ) \%>\%
  addGeoJSONv2(
    geoJson,
    markerType = "circleMarker",
    stroke = FALSE, fillColor = "black", fillOpacity = 0.7,
    markerOptions = markerOptions(radius = 2)
  )
}

## for more examples see
# browseURL(system.file("examples/draw.R", package = "leaflet.extras"))
# browseURL(system.file("examples/geojsonv2.R", package = "leaflet.extras"))
# browseURL(system.file("examples/search.R", package = "leaflet.extras"))
# browseURL(system.file("examples/TopoJSON.R", package = "leaflet.extras"))

## addGeoJSONChoropleth
\donttest{
geoJson <- readr::read_file(
  "https://rawgit.com/benbalter/dc-maps/master/maps/ward-2012.geojson"
)

leaflet() \%>\%
  addTiles() \%>\%
  setView(-77.0369, 38.9072, 11) \%>\%
  addBootstrapDependency() \%>\%
  enableMeasurePath() \%>\%
  addGeoJSONChoropleth(
    geoJson,
    valueProperty = "AREASQMI",
    scale = c("white", "red"),
    mode = "q",
    steps = 4,
    padding = c(0.2, 0),
    labelProperty = "NAME",
    popupProperty = propstoHTMLTable(
      props = c("NAME", "AREASQMI", "REP_NAME", "WEB_URL", "REP_PHONE", "REP_EMAIL", "REP_OFFICE"),
      table.attrs = list(class = "table table-striped table-bordered"),
      drop.na = TRUE
    ),
    color = "#ffffff", weight = 1, fillOpacity = 0.7,
    highlightOptions = highlightOptions(
      weight = 2, color = "#000000",
      fillOpacity = 1, opacity = 1,
      bringToFront = TRUE, sendToBack = TRUE
    ),
    pathOptions = pathOptions(
      showMeasurements = TRUE,
      measurementOptions = measurePathOptions(imperial = TRUE)
    )
  )
}

## for more examples see
# browseURL(system.file("examples/geojsonv2.R", package = "leaflet.extras"))
# browseURL(system.file("examples/measurePath.R", package = "leaflet.extras"))
# browseURL(system.file("examples/search.R", package = "leaflet.extras"))
# browseURL(system.file("examples/TopoJSON.R", package = "leaflet.extras"))

## addKML
\donttest{
kml <- readr::read_file(
  system.file("examples/data/kml/crimes.kml.zip", package = "leaflet.extras")
)

leaflet() \%>\%
  setView(-77.0369, 38.9072, 12) \%>\%
  addProviderTiles(providers$CartoDB.Positron) \%>\%
  addWebGLKMLHeatmap(kml, size = 20, units = "px") \%>\%
  addKML(
    kml,
    markerType = "circleMarker",
    stroke = FALSE, fillColor = "black", fillOpacity = 1,
    markerOptions = markerOptions(radius = 1)
  )
}

## addKMLChoropleth
\donttest{
kml <- readr::read_file(
  system.file("examples/data/kml/cb_2015_us_state_20m.kml.zip", package = "leaflet.extras")
)

leaflet() \%>\%
  addBootstrapDependency() \%>\%
  setView(-98.583333, 39.833333, 4) \%>\%
  addProviderTiles(providers$CartoDB.Positron) \%>\%
  addKMLChoropleth(
    kml,
    valueProperty = JS(
      "function(feature){
         var props = feature.properties;
         var aland = props.ALAND/100000;
         var awater = props.AWATER/100000;
         return 100*awater/(awater+aland);
      }"
    ),
    scale = "OrRd", mode = "q", steps = 5,
    padding = c(0.2, 0),
    popupProperty = "description",
    labelProperty = "NAME",
    color = "#ffffff", weight = 1, fillOpacity = 1,
    highlightOptions = highlightOptions(
      fillOpacity = 1, weight = 2, opacity = 1, color = "#000000",
      bringToFront = TRUE, sendToBack = TRUE
    ),
    legendOptions = legendOptions(
      title = "\% of Water Area",
      numberFormatOptions = list(
        style = "decimal",
        maximumFractionDigits = 2
      )
    )
  )
}

## addCSV
\donttest{
csv <- readr::read_file(
  system.file("examples/data/csv/world_airports.csv.zip", package = "leaflet.extras")
)

leaflet() \%>\%
  setView(0, 0, 2) \%>\%
  addProviderTiles(providers$CartoDB.DarkMatterNoLabels) \%>\%
  addCSV(
    csv,
    csvParserOptions("latitude_deg", "longitude_deg"),
    markerType = "circleMarker",
    stroke = FALSE, fillColor = "red", fillOpacity = 1,
    markerOptions = markerOptions(radius = 0.5)
  )
}

## addGPX
\donttest{
airports <- readr::read_file(
  system.file("examples/data/gpx/md-airports.gpx.zip", package = "leaflet.extras")
)

leaflet() \%>\%
  addBootstrapDependency() \%>\%
  setView(-76.6413, 39.0458, 8) \%>\%
  addProviderTiles(
    providers$CartoDB.Positron,
    options = providerTileOptions(detectRetina = TRUE)
  ) \%>\%
  addWebGLGPXHeatmap(airports, size = 20000, group = "airports", opacity = 0.9) \%>\%
  addGPX(
    airports,
    markerType = "circleMarker",
    stroke = FALSE, fillColor = "black", fillOpacity = 1,
    markerOptions = markerOptions(radius = 1.5),
    group = "airports"
  )
}

## for a larger example see
# browseURL(system.file("examples/GPX.R", package = "leaflet.extras"))

}
