% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weatherMarkers.R
\name{weatherIconList}
\alias{weatherIconList}
\alias{[.leaflet_weather_icon_set}
\alias{makeWeatherIcon}
\alias{weatherIcons}
\alias{addWeatherMarkers}
\title{Make weather-icon set}
\usage{
weatherIconList(...)

\method{[}{leaflet_weather_icon_set}(x, i)

makeWeatherIcon(
  icon,
  markerColor = "red",
  iconColor = "white",
  extraClasses = NULL
)

weatherIcons(
  icon,
  markerColor = "red",
  iconColor = "white",
  extraClasses = NULL
)

addWeatherMarkers(
  map,
  lng = NULL,
  lat = NULL,
  layerId = NULL,
  group = NULL,
  icon = NULL,
  popup = NULL,
  popupOptions = NULL,
  label = NULL,
  labelOptions = NULL,
  options = leaflet::markerOptions(),
  clusterOptions = NULL,
  clusterId = NULL,
  data = leaflet::getMapData(map)
)
}
\arguments{
\item{...}{icons created from \code{\link{makeWeatherIcon}()}}

\item{x}{icons}

\item{i}{offset}

\item{icon}{the weather icon name w/o the "wi-" prefix. For a full list see \url{https://erikflowers.github.io/weather-icons/}}

\item{markerColor}{color of the marker}

\item{iconColor}{color of the weather icon}

\item{extraClasses}{Character vector of extra classes.}

\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}()}}

\item{lng}{a numeric vector of longitudes, or a one-sided formula of the form
\code{~x} where \code{x} is a variable in \code{data}; by default (if not
explicitly provided), it will be automatically inferred from \code{data} by
looking for a column named \code{lng}, \code{long}, or \code{longitude}
(case-insensitively)}

\item{lat}{a vector of latitudes or a formula (similar to the \code{lng}
argument; the names \code{lat} and \code{latitude} are used when guessing
the latitude column from \code{data})}

\item{layerId}{the layer id}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{popup}{a character vector of the HTML content for the popups (you are
recommended to escape the text using \code{\link[htmltools]{htmlEscape}()}
for security reasons)}

\item{popupOptions}{A Vector of \code{\link[leaflet]{popupOptions}} to provide popups}

\item{label}{a character vector of the HTML content for the labels}

\item{labelOptions}{A Vector of \code{\link[leaflet]{labelOptions}} to provide label
options for each label. Default \code{NULL}}

\item{options}{a list of extra options for tile layers, popups, paths
(circles, rectangles, polygons, ...), or other map elements}

\item{clusterOptions}{if not \code{NULL}, markers will be clustered using
\href{https://github.com/Leaflet/Leaflet.markercluster}{Leaflet.markercluster};
 you can use \code{\link[leaflet]{markerClusterOptions}()} to specify marker cluster
options}

\item{clusterId}{the id for the marker cluster layer}

\item{data}{the data object from which the argument values are derived; by
default, it is the \code{data} object provided to \code{leaflet()}
initially, but can be overridden}
}
\description{
An icon can be represented as a list of the form \code{list(icon, markerColor,
...)}. This function is vectorized over its arguments to create a list of
icon data. Shorter argument values will be re-cycled. \code{NULL} values for
these arguments will be ignored.
}
\examples{

iconSet <- weatherIconList(
  hurricane = makeWeatherIcon(icon = "hurricane"),
  tornado = makeWeatherIcon(icon = "tornado")
)

iconSet[c("hurricane", "tornado")]
leaflet() \%>\%
  addTiles() \%>\%
  addWeatherMarkers(
    lng = -118.456554, lat = 34.078039,
    label = "This is a label",
    icon = makeWeatherIcon(
      icon = "hot",
      iconColor = "#ffffff77",
      markerColor = "blue"
    )
  )

## for more examples see
# browseURL(system.file("examples/weatherIcons.R", package = "leaflet.extras"))
}
