% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webGLHeatmap.R
\name{addWebGLHeatmap}
\alias{addWebGLHeatmap}
\alias{addWebGLGeoJSONHeatmap}
\alias{addWebGLKMLHeatmap}
\alias{addWebGLCSVHeatmap}
\alias{addWebGLGPXHeatmap}
\alias{removeWebGLHeatmap}
\alias{clearWebGLHeatmap}
\title{Add a webgl heatmap}
\usage{
addWebGLHeatmap(
  map,
  lng = NULL,
  lat = NULL,
  intensity = NULL,
  layerId = NULL,
  group = NULL,
  size = "30000",
  units = "m",
  opacity = 1,
  gradientTexture = NULL,
  alphaRange = 1,
  data = leaflet::getMapData(map)
)

addWebGLGeoJSONHeatmap(
  map,
  geojson,
  layerId = NULL,
  group = NULL,
  intensityProperty = NULL,
  size = "30000",
  units = "m",
  opacity = 1,
  gradientTexture = NULL,
  alphaRange = 1
)

addWebGLKMLHeatmap(
  map,
  kml,
  layerId = NULL,
  group = NULL,
  intensityProperty = NULL,
  size = "30000",
  units = "m",
  opacity = 1,
  gradientTexture = NULL,
  alphaRange = 1
)

addWebGLCSVHeatmap(
  map,
  csv,
  csvParserOptions,
  layerId = NULL,
  group = NULL,
  intensityProperty = NULL,
  size = "30000",
  units = "m",
  opacity = 1,
  gradientTexture = NULL,
  alphaRange = 1
)

addWebGLGPXHeatmap(
  map,
  gpx,
  layerId = NULL,
  group = NULL,
  intensityProperty = NULL,
  size = "30000",
  units = "m",
  opacity = 1,
  gradientTexture = NULL,
  alphaRange = 1
)

removeWebGLHeatmap(map, layerId)

clearWebGLHeatmap(map)
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}()}}

\item{lng}{a numeric vector of longitudes, or a one-sided formula of the form
\code{~x} where \code{x} is a variable in \code{data}; by default (if not
explicitly provided), it will be automatically inferred from \code{data} by
looking for a column named \code{lng}, \code{long}, or \code{longitude}
(case-insensitively)}

\item{lat}{a vector of latitudes or a formula (similar to the \code{lng}
argument; the names \code{lat} and \code{latitude} are used when guessing
the latitude column from \code{data})}

\item{intensity}{intensity of the heat. A vector of numeric values or a formula.}

\item{layerId}{the layer id}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{size}{in meters or pixels}

\item{units}{either "m" or "px"}

\item{opacity}{for the canvas element}

\item{gradientTexture}{Alternative colors for heatmap.
allowed values are "skyline", "deep-sea"}

\item{alphaRange}{adjust transparency by changing to value between 0 and 1}

\item{data}{the data object from which the argument values are derived; by
default, it is the \code{data} object provided to \code{leaflet()}
initially, but can be overridden}

\item{geojson}{The geojson or topojson url or contents as string.}

\item{intensityProperty}{The property to use for determining the intensity at a point.
Can be a "string" or a JS function, or NULL.}

\item{kml}{The KML url or contents as string.}

\item{csv}{The CSV url or contents as string.}

\item{csvParserOptions}{options for parsing the CSV.
Use \code{\link{csvParserOptions}}() to supply csv parser options.}

\item{gpx}{The GPX url or contents as string.}
}
\description{
Add a webgl heatmap

Adds a heatmap with data from a GeoJSON/TopoJSON file/url

Adds a heatmap with data from a KML file/url

Adds a heatmap with data from a CSV file/url

Adds a heatmap with data from a GPX file/url

removes the webgl heatmap

clears the webgl heatmap
}
\examples{
## addWebGLHeatmap
leaflet(quakes) \%>\%
  addProviderTiles(providers$CartoDB.DarkMatter) \%>\%
  addWebGLHeatmap(lng = ~long, lat = ~lat, size = 60000)

## for more examples see
# browseURL(system.file("examples/webglHeatmaps.R", package = "leaflet.extras"))
## addWebGLGeoJSONHeatmap
\donttest{
geoJson <- readr::read_file(
  "https://rawgit.com/benbalter/dc-maps/master/maps/historic-landmarks-points.geojson"
)

leaflet() \%>\%
  setView(-77.0369, 38.9072, 12) \%>\%
  addProviderTiles(providers$CartoDB.Positron) \%>\%
  addWebGLGeoJSONHeatmap(
    geoJson,
    size = 30, units = "px"
  ) \%>\%
  addGeoJSONv2(
    geoJson,
    markerType = "circleMarker",
    stroke = FALSE, fillColor = "black", fillOpacity = 0.7,
    markerOptions = markerOptions(radius = 2)
  )
}

## for more examples see
# browseURL(system.file("examples/geojsonV2.R", package = "leaflet.extras"))
# browseURL(system.file("examples/TopoJSON.R", package = "leaflet.extras"))
## addWebGLKMLHeatmap
\donttest{
kml <- readr::read_file(
  system.file("examples/data/kml/crimes.kml.zip", package = "leaflet.extras")
)

leaflet() \%>\%
  setView(-77.0369, 38.9072, 12) \%>\%
  addProviderTiles(providers$CartoDB.Positron) \%>\%
  addWebGLKMLHeatmap(kml, size = 20, units = "px") \%>\%
  addKML(
    kml,
    markerType = "circleMarker",
    stroke = FALSE, fillColor = "black", fillOpacity = 1,
    markerOptions = markerOptions(radius = 1)
  )
}

## addWebGLCSVHeatmap
\donttest{
csv <- readr::read_file(
  system.file("examples/data/csv/world_airports.csv.zip", package = "leaflet.extras")
)

leaflet() \%>\%
  setView(0, 0, 2) \%>\%
  addProviderTiles(providers$CartoDB.DarkMatterNoLabels) \%>\%
  addWebGLCSVHeatmap(
    csv,
    csvParserOptions("latitude_deg", "longitude_deg"),
    size = 10, units = "px"
  )
}

\donttest{
airports <- readr::read_file(
  system.file("examples/data/gpx/md-airports.gpx.zip", package = "leaflet.extras")
)

leaflet() \%>\%
  addBootstrapDependency() \%>\%
  setView(-76.6413, 39.0458, 8) \%>\%
  addProviderTiles(
    providers$CartoDB.Positron,
    options = providerTileOptions(detectRetina = TRUE)
  ) \%>\%
  addWebGLGPXHeatmap(
    airports,
    size = 20000,
    group = "airports",
    opacity = 0.9
  ) \%>\%
  addGPX(
    airports,
    markerType = "circleMarker",
    stroke = FALSE, fillColor = "black", fillOpacity = 1,
    markerOptions = markerOptions(radius = 1.5),
    group = "airports"
  )
}


## for a larger example see
# browseURL(system.file("examples/GPX.R", package = "leaflet.extras"))
}
