% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{groupOptions}
\alias{groupOptions}
\title{Set options on layer groups}
\usage{
groupOptions(map, group, zoomLevels = NULL)
}
\arguments{
\item{map}{the map to modify}

\item{group}{character vector of one or more group names to set options on}

\item{zoomLevels}{numeric vector of zoom levels at which group(s) should be
visible, or \code{TRUE} to display at all zoom levels}
}
\description{
Change options on layer groups. Currently the only option is to control what
zoom levels a layer group will be displayed at. The \code{zoomLevels} option
is not compatible with \link[=addLayersControl]{layers control}; do not both
assign a group to zoom levels and use it with \code{addLayersControl()}.
}
\examples{
pal <- colorQuantile("YlOrRd", quakes$mag)

leaflet() \%>\%
  # Basic markers
  addTiles(group = "basic") \%>\%
  addMarkers(data = quakes, group = "basic") \%>\%
  # When zoomed in, we'll show circles at the base of each marker whose
  # radius and color reflect the magnitude
  addProviderTiles(providers$Esri.WorldTopoMap, group = "detail") \%>\%
  addCircleMarkers(data = quakes, group = "detail", fillOpacity = 0.5,
    radius = ~mag * 5, color = ~pal(mag), stroke = FALSE) \%>\%
  # Set the detail group to only appear when zoomed in
  groupOptions("detail", zoomLevels = 7:18)

}
