% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_cs.R
\name{crop_cs}
\alias{crop_cs}
\title{Crop conductanceMatrix to extent}
\usage{
crop_cs(x, extent)
}
\arguments{
\item{x}{\code{spatRaster}}

\item{extent}{\code{sf object or terra SpatRaster}. Extent obtained from object using terra::ext}
}
\description{
Crop conductanceMatrix to extent
}
\details{
conductanceMatrix cropped to extent of supplied \code{Sf object} or \code{terra SpatRaster}. conductanceMatrix spatRaster dimensions and Matrix dimensions update to reflect cropped extent
}
\examples{

r <- terra::rast(system.file("extdata/SICILY_1000m.tif", package="leastcostpath"))

slope_cs <- create_slope_cs(x = r, cost_function = "tobler", neighbours = 4)

ext <- sf::st_as_sfc(sf::st_bbox(rasterise(slope_cs)))
ext <- sf::st_buffer(ext, dist = -75000)
ext <- sf::st_as_sf(ext)

slope_cs_cropped <- crop_cs(slope_cs, extent = ext)
}
\author{
Joseph Lewis
}
