% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ogive.R
\name{ogive}
\alias{ogive}
\alias{ogive.leem}
\title{Ogive chart}
\usage{
ogive(x, ...)

\method{ogive}{leem}(
  x,
  freq = "a",
  decreasing = FALSE,
  both = FALSE,
  bars = FALSE,
  histogram = FALSE,
  bg = TRUE,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  grids = grid(col = "white"),
  bgcol = "gray",
  bgborder = NA,
  barcol = "yellow",
  histcol = barcol,
  barborder = "gray",
  histborder = barborder,
  type = "b",
  lpcol = "black",
  lwd = 2,
  pch = 19,
  lty = 2,
  ...
)
}
\arguments{
\item{x}{R object (list) of class leem. Use \code{new_leem()} function.}

\item{...}{further arguments passed to or from other methods.}

\item{freq}{Character argument. Type of frequency with options: \code{"a"} (absolute and default), \code{"r"} relative and \code{"p"} percentage.}

\item{decreasing}{Logical argument. Default is \code{FALSE}. If \code{decreasing = FALSE}, it represents the "ogive larger than", if \code{decreasing = TRUE}, it represents the "ogive less than".}

\item{both}{Logical argument. Default is \code{FALSE}. If \code{both = TRUE}, both o will be plotted. If \code{both = FALSE} otherside.}

\item{bars}{Logical argument. Default is \code{FALSE}. If \code{bars = TRUE}, the bars of the accumulated frequency will be inserted to plot, according to the \code{decreasing} argument. If \code{bars = FALSE} otherside.}

\item{histogram}{Logical argument. Default is \code{FALSE}. If \code{histogram = TRUE}, the histogram will be inserted to plot.}

\item{bg}{Logical argument. Default is \code{TRUE}, it displays the background, and \code{bg = FALSE} otherwise.}

\item{main}{Insert the plot title. The default is \code{NULL}.}

\item{xlab}{Insert the title of the x-axis graphic label. The default is \code{NULL}.}

\item{ylab}{Insert the title of the y-axis graphic label. The default is \code{NULL}.}

\item{grids}{Insert grids to plot. The default is \code{grid(col = "white")}.}

\item{bgcol}{Insert the background color. This argument is only valid when \code{bg = TRUE}. The default is \code{bgcol="gray"}.}

\item{bgborder}{Insert the background border color. This argument is only valid when \code{bg = TRUE}. The default is bgborder = NA.}

\item{barcol}{Insert the barplot color. The default is \code{barcol = "yellow"}. This argument is only valid when \code{bars = TRUE}.}

\item{histcol}{Insert the histogram color. The default is \code{histcol = barcol}. This argument is only valid when \code{histogram = TRUE}.}

\item{barborder}{Insert the barplot border color. This argument is only valid when \code{bars = TRUE}. The default is barborder = "gray".}

\item{histborder}{Insert the histogram border color. This argument is only valid when \code{histogram = TRUE}. The default is histborder = barborder.}

\item{type}{Type of plot. The default is \code{type = "b"}, i.e., line and points. See \code{\link{graphical parameter}} for details.}

\item{lpcol}{Type of line color. The default is \code{lpcol = "black"}.}

\item{lwd}{numeric argument. The line width. The default is  \code{lwd = 2}.}

\item{pch}{Type of point. The default is  \code{pch = 19}.}

\item{lty}{Type of line. The default is  \code{lty = 2}.}
}
\value{
Ogive plot.
}
\description{
Generic function that plots the culmulative frequency curve.
}
\examples{
library(leem)
# Example 1 - Both ogives
rnorm(36, 100, 50) |> new_leem(variable = 2) |> tabfreq() |> ogive(both = TRUE)

# Example 2 - Insert barplot
rnorm(36, 100, 50) |> new_leem(variable = 2) |> tabfreq() |> ogive(both = TRUE, bars = TRUE)
# Example 3 - Insert histogram
rnorm(36, 100, 50) |> new_leem(variable = 2) |> tabfreq() |> ogive(both = TRUE, histogram = TRUE)

}
