% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{polyfreq.leem}
\alias{polyfreq.leem}
\title{Frequency polygon Graph}
\usage{
\method{polyfreq}{leem}(
  x,
  freq = "a",
  type = "b",
  bars = TRUE,
  bg = TRUE,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  grids = grid(col = "white"),
  bgcol = "gray",
  bgborder = NA,
  barcol = "yellow",
  barborder = "gray",
  lpcol = "black",
  lwd = 2,
  pch = 19,
  lty = 2,
  ...
)
}
\arguments{
\item{x}{R object (list) of class leem. Use \code{new_leem()} function.}

\item{freq}{Character argument. Type of frequency with options: \code{"a"} (absolute and default), \code{"r"} relative and \code{"p"} percentage.}

\item{type}{Type of plot. The default is \code{type = "b"}, i.e., line and points. See \code{\link{graphical parameter}} for details.}

\item{bars}{Logical argument. Default is \code{FALSE}. If \code{bars = TRUE}, the histogram will be inserted to plot.}

\item{bg}{Logical argument. Default is \code{TRUE}, it displays the background, and \code{bg = FALSE} otherwise.}

\item{main}{Insert the plot title.  The default is \code{NULL}.}

\item{xlab}{Insert the title of the x-axis graphic label. The default is \code{NULL}.}

\item{ylab}{Insert the title of the y-axis graphic label. The default is \code{NULL}.}

\item{grids}{Insert grids to plot. The default is \code{grid(col = "white")}.}

\item{bgcol}{Insert the background color. This argument is only valid when \code{bg = TRUE}. The default is \code{bgcol="gray"}.}

\item{bgborder}{Insert the background border color. This argument is only valid when \code{bg = TRUE}. The default is bgborder = NA.}

\item{barcol}{Insert the barplot color. The default is \code{barcol = "yellow"}. This argument is only valid when \code{bars = TRUE}.}

\item{barborder}{Insert the barplot border color. This argument is only valid when \code{bars = TRUE}. The default is barborder = "gray".}

\item{lpcol}{Type of line color. The default is \code{lpcol = "black"}.}

\item{lwd}{numeric argument. The line width. The default is  \code{lwd = 2}.}

\item{pch}{Type of point. The default is  \code{pch = 19}.}

\item{lty}{Type of line. The default is  \code{lty = 2}.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Plot the frequency polygon curve.
}
\examples{
# Example 1
library(leem)
rnorm(36, 100, 50) |> new_leem(variable = "continuous") |> tabfreq() |> polyfreq()
}
