% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-methods.R
\name{CoverTree}
\alias{CoverTree}
\title{CoverTree - Nearest Neighbor Search}
\value{
R6 Class of CoverTree
}
\description{
Wrapper R6 Class of FNN::get.knnx function that can be used for LESSRegressor and LESSClassifier
}
\details{
The cover tree is O(n) space data structure which allows us to answer queries in the same O(log(n)) time as kd tree given a fixed intrinsic dimensionality.
Templated code from \url{https://hunch.net/~jl/projects/cover_tree/cover_tree.html} is used.
}
\examples{

## ------------------------------------------------
## Method `CoverTree$new`
## ------------------------------------------------

data(abalone)
ct <- CoverTree$new(abalone[1:100,])

## ------------------------------------------------
## Method `CoverTree$query`
## ------------------------------------------------

res <- ct$query(abalone[1:3,], k=2)
print(res)
}
\seealso{
\code{\link[FNN:get.knn]{FNN::get.knnx()}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CoverTree-new}{\code{CoverTree$new()}}
\item \href{#method-CoverTree-query}{\code{CoverTree$query()}}
\item \href{#method-CoverTree-clone}{\code{CoverTree$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CoverTree-new"></a>}}
\if{latex}{\out{\hypertarget{method-CoverTree-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of R6 Class of CoverTree
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CoverTree$new(X = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{An \strong{M x d} data.frame or matrix, where each of the \strong{M} rows is a point or a (column) vector (where \strong{d=1}).}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(abalone)
ct <- CoverTree$new(abalone[1:100,])
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CoverTree-query"></a>}}
\if{latex}{\out{\hypertarget{method-CoverTree-query}{}}}
\subsection{Method \code{query()}}{
Finds the p number of near neighbours for each point in an input/output dataset.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CoverTree$query(query_X = private$X, k = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query_X}}{A set of \strong{N x d} points that will be queried against \code{X}. \strong{d}, the number of columns, must be the same as \code{X}.
If missing, defaults to  \code{X}.}

\item{\code{k}}{The maximum number of nearest neighbours to compute (deafults to 1).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{list} of length 2 with elements:\tabular{ll}{
\code{nn.idx} \tab A \strong{N x k} integer matrix returning the near neighbour indices. \cr
\tab \cr
\code{nn.dists} \tab A \strong{N x k} matrix returning the near neighbour Euclidean distances \cr
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{res <- ct$query(abalone[1:3,], k=2)
print(res)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CoverTree-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CoverTree-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CoverTree$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
