% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressors.R
\name{KNeighborsRegressor}
\alias{KNeighborsRegressor}
\title{KNeighborsRegressor}
\value{
R6 Class of KNeighborsRegressor
}
\description{
Wrapper R6 Class of caret::knnreg function that can be used for LESSRegressor and LESSClassifier
}
\examples{

## ------------------------------------------------
## Method `KNeighborsRegressor$new`
## ------------------------------------------------

knr <- KNeighborsRegressor$new()
knr <- KNeighborsRegressor$new(k = 5)

## ------------------------------------------------
## Method `KNeighborsRegressor$fit`
## ------------------------------------------------

data(abalone)
split_list <- train_test_split(abalone[1:100,], test_size =  0.3)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

knr <- KNeighborsRegressor$new()
knr$fit(X_train, y_train)

## ------------------------------------------------
## Method `KNeighborsRegressor$predict`
## ------------------------------------------------

knr <- KNeighborsRegressor$new()
knr$fit(X_train, y_train)
preds <- knr$predict(X_test)

knr <- KNeighborsRegressor$new()
preds <- knr$fit(X_train, y_train)$predict(X_test)

preds <- KNeighborsRegressor$new()$fit(X_train, y_train)$predict(X_test)
print(head(matrix(c(y_test, preds), ncol = 2, dimnames = (list(NULL, c("True", "Prediction"))))))

## ------------------------------------------------
## Method `KNeighborsRegressor$get_estimator_type`
## ------------------------------------------------

knr$get_estimator_type()
}
\seealso{
\code{\link[caret:knnreg]{caret::knnreg()}}
}
\section{Super classes}{
\code{\link[less:BaseEstimator]{less::BaseEstimator}} -> \code{\link[less:SklearnEstimator]{less::SklearnEstimator}} -> \code{KNeighborsRegressor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-KNeighborsRegressor-new}{\code{KNeighborsRegressor$new()}}
\item \href{#method-KNeighborsRegressor-fit}{\code{KNeighborsRegressor$fit()}}
\item \href{#method-KNeighborsRegressor-predict}{\code{KNeighborsRegressor$predict()}}
\item \href{#method-KNeighborsRegressor-get_estimator_type}{\code{KNeighborsRegressor$get_estimator_type()}}
\item \href{#method-KNeighborsRegressor-clone}{\code{KNeighborsRegressor$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_all_fields"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_all_fields'><code>less::BaseEstimator$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_attributes"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_attributes'><code>less::BaseEstimator$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="set_random_state"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-set_random_state'><code>less::BaseEstimator$set_random_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_isFitted"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_isFitted'><code>less::SklearnEstimator$get_isFitted()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_type"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_type'><code>less::SklearnEstimator$get_type()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KNeighborsRegressor-new"></a>}}
\if{latex}{\out{\hypertarget{method-KNeighborsRegressor-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of R6 Class of KNeighborsRegressor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KNeighborsRegressor$new(k = 5)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{k}}{Number of neighbors considered (defaults to 5).}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{knr <- KNeighborsRegressor$new()
knr <- KNeighborsRegressor$new(k = 5)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KNeighborsRegressor-fit"></a>}}
\if{latex}{\out{\hypertarget{method-KNeighborsRegressor-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the k-nearest neighbors regressor from the training set (X, y).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KNeighborsRegressor$fit(X, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{2D matrix or dataframe that includes predictors}

\item{\code{y}}{1D vector or (n,1) dimensional matrix/dataframe that includes response variables}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Fitted R6 Class of KNeighborsRegressor
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(abalone)
split_list <- train_test_split(abalone[1:100,], test_size =  0.3)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

knr <- KNeighborsRegressor$new()
knr$fit(X_train, y_train)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KNeighborsRegressor-predict"></a>}}
\if{latex}{\out{\hypertarget{method-KNeighborsRegressor-predict}{}}}
\subsection{Method \code{predict()}}{
Predict regression value for X0.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KNeighborsRegressor$predict(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{2D matrix or dataframe that includes predictors}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The predict values.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{knr <- KNeighborsRegressor$new()
knr$fit(X_train, y_train)
preds <- knr$predict(X_test)

knr <- KNeighborsRegressor$new()
preds <- knr$fit(X_train, y_train)$predict(X_test)

preds <- KNeighborsRegressor$new()$fit(X_train, y_train)$predict(X_test)
print(head(matrix(c(y_test, preds), ncol = 2, dimnames = (list(NULL, c("True", "Prediction"))))))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KNeighborsRegressor-get_estimator_type"></a>}}
\if{latex}{\out{\hypertarget{method-KNeighborsRegressor-get_estimator_type}{}}}
\subsection{Method \code{get_estimator_type()}}{
Auxiliary function returning the estimator type e.g 'regressor', 'classifier'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KNeighborsRegressor$get_estimator_type()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{knr$get_estimator_type()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KNeighborsRegressor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-KNeighborsRegressor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KNeighborsRegressor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
