% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptSplitCheck.R
\name{reptSplitCheck}
\alias{reptSplitCheck}
\title{Check for potential taxonomic splits in a query}
\usage{
reptSplitCheck(
  x,
  pubDate = NULL,
  includeAll = FALSE,
  verbose = TRUE,
  cores = 1,
  showProgress = TRUE,
  exact = FALSE
)
}
\arguments{
\item{x}{A character vector of species names to check. Usually from a database.}

\item{pubDate}{Integer. An year (e.g., 2019) used as a reference date from when to check potential taxonomic split}

\item{includeAll}{Logical; If \code{TRUE}, include all species described since \code{pubDate} regardless of if it is already included in the queried species list. Default is \code{FALSE}}

\item{verbose}{Logical; If \code{TRUE}, prints progress messages. Default is \code{TRUE}.}

\item{cores}{Integer. Number of CPU cores to use for parallel processing. Default is \code{cores = 1}.}

\item{showProgress}{Logical. If \code{TRUE}, prints data sampling progress. Default is \code{TRUE}.}

\item{exact}{Logical. Will search queried names for exact matches only (e.g., does not retrieve "Tantilla cf. melanocephala" when searching for "Tantilla melanocephala"). Default is \code{FALSE}.}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{query}: the original input names.
\item \code{RDB}: the best-matching valid names according to The Reptile Database.
\item \code{status}: a status label indicating the result of the match (\code{"check_split"}, \code{"up_to_date"}, \code{"not_found"}, or \code{"failed"}).
}
}
\description{
Check for potential taxonomic splits in a query
}
\examples{
query <- c(
"Atractus dapsilis",
"Atractus trefauti",
"Atractus snethlageae",
"Tantilla melanocephala",
"Oxybelis aeneus",
"Oxybelis rutherfordi",
"Vieira-Alencar authoristicus",
"Oxybelis aeneus",
"Bothrops pauloensis")

\donttest{
result <- reptSplitCheck(x=query,
                        pubDate = 2019,
                        cores = 2,
                        showProgress = FALSE)

result <- reptSplitCheck(x=query,
                        pubDate = 2019,
                        cores = 2,
                        showProgress = FALSE,
                        includeAll = TRUE)
}
}
