% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptTidySyn.R
\name{reptTidySyn}
\alias{reptTidySyn}
\title{Printing reptSync and reptSplitCheck outcomes in a tidy way}
\usage{
reptTidySyn(df, filter = NULL)
}
\arguments{
\item{df}{The data frame derivated from \code{reptSync}}

\item{filter}{Logical. If \code{TRUE} will print only the species entries with unresolved nomenclature (e.g.: ambiguous or not_found). Default is \code{TRUE}}
}
\value{
Invisibly returns \code{NULL}. Used for side-effect printing only.
}
\description{
Prints the data frame derived from \code{reptSync} or \code{reptSplitCheck} in a tidy way.
Optionally, it filters the data frame for species with unresolved nomenclature only.
}
\examples{
df <- data.frame(
  species = c("Genus epithet 1", 
              "Genus epithet 2",
              "Genus epithet 3",
              "Genus epithet 4",
              "Genus epithet 5"),
  synonyms = c("Genus epithet 1.1; Genus epithet 1.2",
                "Genus epithet 2",
                "Genus epithet 3",
                "Not found",
                "Genus epithet 5.1; Genus epithet 5.2; Genus epithet 5.3"),
  status = c("ambiguous", 
             "updated",
             "up_to_date",
             "not_found",
             "ambiguous"),
  stringsAsFactors = FALSE
)
reptTidySyn(df, filter = c("ambiguous", "not_found"))

}
