% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_conditional_independence.R
\name{interpolate_conditional_density}
\alias{interpolate_conditional_density}
\title{Interpolate a univariate conditional density function}
\usage{
interpolate_conditional_density(lg_object, condition, nodes,
  extend = 0.3,
  gaussian_scale = lg_object$transform_to_marginal_normality)
}
\arguments{
\item{lg_object}{An object of type \code{lg}, as produced by the
\code{lg_main}-function}

\item{condition}{A vector with conditions for the variables that we condition
upon. Must have exactly one more element than there are columns in the data}

\item{nodes}{Either the number of equidistant nodes to generate, or a vector
of nodes supplied by the user}

\item{extend}{How far to extend the grid beyond the extreme data points, in
share of the range}

\item{gaussian_scale}{Stay on the standard Gaussian scale, useful for the
accept-reject algorithm}
}
\description{
Estimates the conditional density function for one free variable on a grid.
Returns a function that interpolates between these grid points so that it can
be evaluated more quickly, without new optimizations.
}
