% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{compute_dG_u_dlambda_xy}
\alias{compute_dG_u_dlambda_xy}
\title{Compute Derivative of \eqn{\textbf{U}\textbf{G}\textbf{X}^{T}\textbf{y}} with Respect to Lambda}
\usage{
compute_dG_u_dlambda_xy(
  AGAInv_AGXy,
  AGAInv,
  G,
  A,
  dG_dlambda,
  nc,
  nca,
  K,
  Xy,
  Ghalf,
  dGhalf,
  GhalfXy_temp,
  parallel,
  cl,
  chunk_size,
  num_chunks,
  rem_chunks
)
}
\arguments{
\item{AGAInv_AGXy}{Product of \eqn{(\textbf{A}^{T}\textbf{G}\textbf{A})^{-1}} and \eqn{\textbf{A}^{T}\textbf{G}\textbf{X}^{T}\textbf{y}}}

\item{AGAInv}{Inverse of \eqn{\textbf{A}^{T}\textbf{G}\textbf{A}}}

\item{G}{List of \eqn{\textbf{G}} matrices}

\item{A}{Constraint matrix \eqn{\textbf{A}}}

\item{dG_dlambda}{List of \eqn{d\textbf{G}/d\lambda} matrices}

\item{nc}{Number of columns}

\item{nca}{Number of constraint columns}

\item{K}{Number of partitions minus 1 (\eqn{K})}

\item{Xy}{List of \eqn{\textbf{X}^{T}\textbf{y}} products}

\item{Ghalf}{List of \eqn{\textbf{G}^{1/2}} matrices}

\item{dGhalf}{List of \eqn{d\textbf{G}^{1/2}/d\lambda} matrices}

\item{GhalfXy_temp}{Temporary storage for \eqn{\textbf{G}^{1/2}\textbf{X}^{T}\textbf{y}}}

\item{parallel}{Use parallel processing}

\item{cl}{Cluster object}

\item{chunk_size}{Size of parallel chunks}

\item{num_chunks}{Number of chunks}

\item{rem_chunks}{Remaining chunks}
}
\value{
Vector of derivatives
}
\description{
Compute Derivative of \eqn{\textbf{U}\textbf{G}\textbf{X}^{T}\textbf{y}} with Respect to Lambda
}
\details{
Computes \eqn{d(\textbf{U}\textbf{G}\textbf{X}^{T}\textbf{y})/d\lambda}.
Uses efficient implementation avoiding large matrix construction.
For large problems (\eqn{K \ge 10}, \eqn{nc > 4}), uses chunked parallel processing.
For smaller problems, uses simpler least squares approach based on \eqn{\textbf{G}^{1/2}}.
}
\keyword{internal}
