% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/console_output.R
\name{wrap_text}
\alias{wrap_text}
\title{Produce a nicely-wrapped paragraph for console printing}
\usage{
wrap_text(...)
}
\arguments{
\item{...}{Vectors to be coerced to Character.}
}
\value{
The text in \code{...} will be collapsed and wrapped.
}
\description{
Wrapping text needs to be done separately from actually printing it with
\code{stop} or \code{warning} or \code{message}. This is because these functions typically
also print some information about the environment where they were called.
}
\examples{
\dontrun{
wrapped <- 
wrap_text(
    "Lorem ipsum dolor sit amet, ornare justo condimentum",
    "et sit lorem! Himenaeos, vel et sodales sit.",
    "Eu nulla. Magna ullamcorper nascetur placerat platea.\n\n",
    "Eleifend semper velit sed aliquam, ut ligula non commodo.")

cat(wrapped)

#>  Lorem ipsum dolor sit amet, ornare justo condimentum et sit lorem! 
#>  Himenaeos, vel et sodales sit. Eu nulla. Magna ullamcorper 
#>  nascetur placerat platea. 
#>
#>  Eleifend semper velit sed aliquam, ut ligula non commodo.
}

}
