% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{lievens}
\alias{lievens}
\title{qPCR data sets by Lievens et al. (2012)}
\format{
A \link[tibble:tibble-package]{tibble} providing amplification curve data
in long format. Each row is for an amplification curve point.

\describe{
\item{\code{plate}}{Plate identifier. There is one identifier for each of the four
data sets.}
\item{\code{well}}{Well identifier, i.e. the position within a PCR plate. This
information was not available from the original publication, thus all values
are \code{NA}.}
\item{\code{target}}{Target identifier. In all data sets the target is an amplicon
consisting of soybean Lectin endogene \code{"Le1"}.}
\item{\code{dye}}{Type of fluorescence dye, in this data set it is always SYBR
Green I master mix (Roche) (\code{"SYBR"}).}
\item{\code{inhibitor}}{Name of the molecule used as PCR inhibitor. In the case of
the dilution series the value is \code{"none"}.}
\item{\code{inhibitor_conc}}{Inhibitor concentration. Units are \% (v/v) for
isopropanol, and ug/mL for tannic acid.}
\item{\code{sample}}{Name of the biological sample. Samples have a simple
consecutive identifier: S1, S2, ..., S5.}
\item{\code{sample_type}}{Sample type. All reactions are standard curves, i.e.
\code{"std"}.}
\item{\code{replicate}}{Replicate identifier.}
\item{\code{copies}}{Standard copy number of the amplicon.}
\item{\code{dilution}}{Dilution factor. Higher number means greater dilution, e.g.
\code{5} means a 1:5 (five-fold) dilution relative to most concentrated standard.}
\item{\code{cycle}}{PCR cycle.}
\item{\code{fluor}}{Raw fluorescence values.}
}
}
\source{
\doi{10.1093/nar/gkr775}
}
\description{
One single tabular tidy data set in long format, encompassing three data sets
of five-point, five-fold dilution series: (i) without any inhibitor, (ii)
with isopropanol inhibition and (iii) with tannic acid inhibition. The target
amplicon consisted of a sequence within the soybean Lectin endogene. Please read
the Methods section of Lievens et al. (2012) for more experimental details.

Each data set consists of a five-point, five-fold dilution series spanning an
amplicon copy number range from \eqn{100,000} down to \eqn{160}. Each
concentration is replicated 18 times. Each reaction has been amplified
through 60 cycles.
\subsection{Dilution series}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::filter(lievens, inhibitor == "none")
#> # A tibble: 5,400 x 13
#>    plate well  target dye   inhibitor inhibitor_conc sample sample_type
#>    <fct> <fct> <fct>  <fct> <fct>              <dbl> <fct>  <fct>      
#>  1 soy   <NA>  Le1    SYBR  none                   0 S1     std        
#>  2 soy   <NA>  Le1    SYBR  none                   0 S1     std        
#>  3 soy   <NA>  Le1    SYBR  none                   0 S1     std        
#>  4 soy   <NA>  Le1    SYBR  none                   0 S1     std        
#>  5 soy   <NA>  Le1    SYBR  none                   0 S1     std        
#>  6 soy   <NA>  Le1    SYBR  none                   0 S1     std        
#>  7 soy   <NA>  Le1    SYBR  none                   0 S1     std        
#>  8 soy   <NA>  Le1    SYBR  none                   0 S1     std        
#>  9 soy   <NA>  Le1    SYBR  none                   0 S1     std        
#> 10 soy   <NA>  Le1    SYBR  none                   0 S1     std        
#> # i 5,390 more rows
#> # i 5 more variables: replicate <fct>, copies <int>, dilution <int>,
#> #   cycle <int>, fluor <dbl>
}\if{html}{\out{</div>}}
}

\subsection{Isopropanol inhibition}{

A series of reactions subjected to inhibition by isopropanol with
concentrations: 2.5, 0.5, 0.1, 0.02, and 0.004 \% (v/v). Because samples have
been co-diluted, the initial copy numbers of the target amplicon also follow
the same five-fold progression in tandem: \eqn{100,000}, \eqn{20,000},
\eqn{4,000}, \eqn{800} and \eqn{160} copies.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::filter(lievens, inhibitor == "isopropanol")
#> # A tibble: 5,400 x 13
#>    plate          well  target dye   inhibitor inhibitor_conc sample sample_type
#>    <fct>          <fct> <fct>  <fct> <fct>              <dbl> <fct>  <fct>      
#>  1 soy+isopropan~ <NA>  Le1    SYBR  isopropa~            2.5 S1     std        
#>  2 soy+isopropan~ <NA>  Le1    SYBR  isopropa~            2.5 S1     std        
#>  3 soy+isopropan~ <NA>  Le1    SYBR  isopropa~            2.5 S1     std        
#>  4 soy+isopropan~ <NA>  Le1    SYBR  isopropa~            2.5 S1     std        
#>  5 soy+isopropan~ <NA>  Le1    SYBR  isopropa~            2.5 S1     std        
#>  6 soy+isopropan~ <NA>  Le1    SYBR  isopropa~            2.5 S1     std        
#>  7 soy+isopropan~ <NA>  Le1    SYBR  isopropa~            2.5 S1     std        
#>  8 soy+isopropan~ <NA>  Le1    SYBR  isopropa~            2.5 S1     std        
#>  9 soy+isopropan~ <NA>  Le1    SYBR  isopropa~            2.5 S1     std        
#> 10 soy+isopropan~ <NA>  Le1    SYBR  isopropa~            2.5 S1     std        
#> # i 5,390 more rows
#> # i 5 more variables: replicate <fct>, copies <int>, dilution <int>,
#> #   cycle <int>, fluor <dbl>
}\if{html}{\out{</div>}}
}

\subsection{Tannic acid inhibition}{

A series of reactions subjected to inhibition by tannic acid with
concentrations: 0.2, 0.04, 0.008, 0.0016 and 0.0032 ul/mL. Because samples
have been co-diluted, the initial copy numbers of the target amplicon also
follow the same five-fold progression in tandem: 100,000, 20,000, 4,000, 800
and 160.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::filter(lievens, inhibitor == "tannic acid")
#> # A tibble: 5,400 x 13
#>    plate          well  target dye   inhibitor inhibitor_conc sample sample_type
#>    <fct>          <fct> <fct>  <fct> <fct>              <dbl> <fct>  <fct>      
#>  1 soy+tannic ac~ <NA>  Le1    SYBR  tannic a~            0.2 S1     std        
#>  2 soy+tannic ac~ <NA>  Le1    SYBR  tannic a~            0.2 S1     std        
#>  3 soy+tannic ac~ <NA>  Le1    SYBR  tannic a~            0.2 S1     std        
#>  4 soy+tannic ac~ <NA>  Le1    SYBR  tannic a~            0.2 S1     std        
#>  5 soy+tannic ac~ <NA>  Le1    SYBR  tannic a~            0.2 S1     std        
#>  6 soy+tannic ac~ <NA>  Le1    SYBR  tannic a~            0.2 S1     std        
#>  7 soy+tannic ac~ <NA>  Le1    SYBR  tannic a~            0.2 S1     std        
#>  8 soy+tannic ac~ <NA>  Le1    SYBR  tannic a~            0.2 S1     std        
#>  9 soy+tannic ac~ <NA>  Le1    SYBR  tannic a~            0.2 S1     std        
#> 10 soy+tannic ac~ <NA>  Le1    SYBR  tannic a~            0.2 S1     std        
#> # i 5,390 more rows
#> # i 5 more variables: replicate <fct>, copies <int>, dilution <int>,
#> #   cycle <int>, fluor <dbl>
}\if{html}{\out{</div>}}
}
}
\examples{
lievens

}
\keyword{datasets}
