% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color.R
\name{lx_color}
\alias{lx_color}
\title{change the state of 'LIFX' lamps}
\usage{
lx_color(
  hue = NULL,
  saturation = NULL,
  brightness = NULL,
  kelvin = NULL,
  duration = NULL,
  infrared = NULL,
  color_name = NULL,
  fast = FALSE,
  delta = FALSE,
  selector = "all",
  power = NULL,
  token = lx_get_token()
)
}
\arguments{
\item{hue}{set the hue (0-255)}

\item{saturation}{set the saturation (0-1)}

\item{brightness}{set the brightness (0-1)}

\item{kelvin}{set the color temperature. limits depend on the specific lamp; limits are likely in the range of 2500-9000}

\item{duration}{in seconds, how long to perform the transition}

\item{infrared}{infrared brightness (0-1)}

\item{color_name}{a color name (i.e. "red"), hexadecimal color code (i.e. "#FF0000") or output from lx_color() (in 'LIFX' api format (see \url{https://api.developer.lifx.com/docs/colors}). If this parameter is used, other parameters may be ignored.}

\item{fast}{Executes the query fast, without initial state checks and wait for no results. See \url{https://api.developer.lifx.com/docs/set-state}}

\item{delta}{if set to TRUE, color values (hue, saturation, brightness, kelvin, infrared) are added to the lights' current values. Can not be used in combination with `color_name`}

\item{selector}{'LIFX' api "selector" such as "all", "id:12345", or "location:kitchen". Can be created with \code{\link{lx_selector}} or written manually (see \url{https://api.developer.lifx.com/docs/selectors}}

\item{power}{string - if set to "on", turns the light on, if set to "off" turns it off.}

\item{token}{API token (see ?lx_save_token). If left empty, the token is retrieved from the environmental variable if available. (see \code{\link{lx_save_token}})}
}
\value{
an 'httr' response object (see \code{\link[httr]{response}})
}
\description{
change the state of 'LIFX' lamps
}
\examples{
\dontrun{
lx_color(hue = 200)
lx_color(saturation = 0.8)
lx_color(hue = 200, saturation = 0.5, brightness = 0.5)
lx_color(color_name = 'cyan', brightness = 1)
lx_color(kelvin = 5000, fast = TRUE)
lx_color(brightness = -0.3, delta = TRUE)
}
}
