# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# columbus_poly

library(testthat)

# Test 1: Confirm the object is a data.frame
test_that("columbus_poly is a data.frame", {
  expect_s3_class(columbus_poly, "data.frame")
})

# Test 2: Confirm it has exactly 22 columns
test_that("columbus_poly has 22 columns", {
  expect_equal(length(columbus_poly), 22)
})

# Test 3: Confirm it has exactly 49 rows
test_that("columbus_poly has 49 rows", {
  expect_equal(nrow(columbus_poly), 49)
})

# Test 4: Confirm column names are correct
test_that("columbus_poly has correct column names", {
  expect_named(columbus_poly, c(
    "AREA", "PERIMETER", "COLUMBUS.", "COLUMBUS.I", "POLYID", "NEIG",
    "HOVAL", "INC", "CRIME", "OPEN", "PLUMB", "DISCBD",
    "X", "Y", "AREA", "NSA", "NSB", "EW",
    "CP", "THOUS", "NEIGNO", "PERIM"
  ))
})

# Test 5: Confirm column types are as expected
test_that("columbus_poly columns have correct types", {
  expect_type(columbus_poly$AREA, "double")
  expect_type(columbus_poly$PERIMETER, "double")
  expect_type(columbus_poly$COLUMBUS., "integer")
  expect_type(columbus_poly$COLUMBUS.I, "integer")
  expect_type(columbus_poly$POLYID, "integer")
  expect_type(columbus_poly$NEIG, "integer")
  expect_type(columbus_poly$HOVAL, "double")
  expect_type(columbus_poly$INC, "double")
  expect_type(columbus_poly$CRIME, "double")
  expect_type(columbus_poly$OPEN, "double")
  expect_type(columbus_poly$PLUMB, "double")
  expect_type(columbus_poly$DISCBD, "double")
  expect_type(columbus_poly$X, "double")
  expect_type(columbus_poly$Y, "double")
  expect_type(columbus_poly$AREA.1, "NULL") # Second AREA column
  expect_type(columbus_poly$NSA, "double")
  expect_type(columbus_poly$NSB, "double")
  expect_type(columbus_poly$EW, "double")
  expect_type(columbus_poly$CP, "double")
  expect_type(columbus_poly$THOUS, "double")
  expect_type(columbus_poly$NEIGNO, "double")
  expect_type(columbus_poly$PERIM, "double")
})
