% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Student_t.R
\name{likt}
\alias{likt}
\title{Student's t Log Likelihood Function}
\usage{
likt(x, df, ncp, log = TRUE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{df}{degrees of freedom (\eqn{> 0}, maybe non-integer).  \code{df
      = Inf} is allowed.}

\item{ncp}{non-centrality parameter \eqn{\delta}{delta};
    currently except for \code{rt()}, only for \code{abs(ncp) <= 37.62}.
    If omitted, use the central t distribution.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
A numeric scalar for the log likelihood of the Student's t density
given the data where df and ncp can be held constant or if vector were given
vector will be returned.
}
\description{
The log likelihood of a Student's t density with data, x, df and ncp
parameters.
}
\details{
The log likelihood is the log of a function of parameters given the data.
}
\examples{
likt(x = rt(n = 2, df = 4),
        df = 4)
}
