% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_resfitted.R
\name{gg_resfitted}
\alias{gg_resfitted}
\title{Generate residual plot of residuals against fitted value}
\usage{
gg_resfitted(fitted.lm, scale.factor = 1)
}
\arguments{
\item{fitted.lm}{a fitted linear model (i.e. lm, glm) that contains fitted regression}

\item{scale.factor}{numeric; scales the point size and linewidth to allow customized viewing. Defaults to 1.}
}
\value{
A ggplot object
}
\description{
Generate residual plot of residuals against fitted value
}
\examples{
library(MASS)
data(Cars93)
cars_lm <- lm(Price ~ Passengers + Length + RPM, data = Cars93)
gg_resfitted(cars_lm)

}
