% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{backnow_cm}
\alias{backnow_cm}
\title{Get Bayesian Back-calculation Estimates and Model Diagnostics}
\usage{
backnow_cm(
  outcome,
  days,
  week,
  weekend,
  iter,
  sigma,
  maxdelay,
  si,
  size,
  workerID,
  printProgress,
  cd = NULL
)
}
\arguments{
\item{outcome}{Vector of outcomes; difference between report and onset times}

\item{days}{Vector of days when the report is given, aligned from the minimum report day}

\item{week}{Vector indicating the week of the report, assumes no change within the week}

\item{weekend}{Binary vector indicating if the outcome was reported during a weekend}

\item{iter}{Number of iterations for the Bayesian back-calculation algorithm}

\item{sigma}{The standard deviation for the normal distribution}

\item{maxdelay}{The maximum delay parameter for the negative binomial distribution}

\item{si}{Serial interval vector}

\item{size}{The size parameter for the negative binomial distribution}

\item{workerID}{Identifier for the parallel worker}

\item{printProgress}{Flag to print the progress information}

\item{cd}{second size parameter, unused}
}
\value{
output A list object that contains the back-calculated estimates and model diagnostics
}
\description{
This function performs Bayesian back-calculation, imputation of missing delays, and nowcasting based on the provided data.
}
\examples{
\donttest{
data("sample_onset_dates")
data("sample_report_dates")
line_list <- create_linelist(sample_report_dates, sample_onset_dates)
sip <- si(14, 4.29, 1.18)
results <- run_backnow(
 line_list, 
  MAX_ITER = as.integer(2000), 
  norm_sigma = 0.5, 
  sip = sip,
  NB_maxdelay = as.integer(20), 
  NB_size = as.integer(6), 
  workerID = 1, 
  printProgress = 1, 
 preCalcTime = TRUE)
}
}
