% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dummy}
\alias{dummy}
\title{Generate Dummy Variables Matrix for Weeks and Weekends}
\usage{
dummy(week, weekend)
}
\arguments{
\item{week}{An integer vector representing the week number of each observation.
Each element denotes the week during which a specific event occurred.}

\item{weekend}{A binary integer vector (elements being 0 or 1) indicating whether
each observation corresponds to a weekend. Here, `1` indicates a weekend and `0` a weekday.}
}
\value{
A numeric matrix where each row corresponds to an observation and each column
        to a week, with an additional final column for weekend indicators. The elements
        of the matrix are dummy variables (0 or 1); each row contains exactly one '1' in
        one of the first several columns corresponding to the week of the observation,
        and a '1' or '0' in the last column indicating weekend status.
}
\description{
This function creates a matrix of dummy variables based on reported weeks and weekend indicators.
Each column in the resulting matrix corresponds to a specific week, except for the last column,
which indicates whether the date falls on a weekend. This matrix is typically used in regression
models where week-specific effects are to be adjusted along with the effect of weekends.
}
\examples{
week <- c(1, 1, 1, 2, 2, 3, 3, 3, 3, 3)
weekend <- c(0, 1, 0, 0, 1, 0, 0, 1, 1, 0)
dummy_vars <- dummy(week, weekend)
}
