% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pnb}
\alias{pnb}
\title{Compute Cumulative Distribution Function for Negative Binomial Distribution}
\usage{
pnb(x, r, m)
}
\arguments{
\item{x}{Non-negative integer specifying the number of successes for which the CDF is computed.
This value must be non-negative as it represents the number of successes in the distribution.}

\item{r}{Dispersion parameter of the distribution, a positive real number.
Higher values of 'r' indicate a higher probability of counts clustering around the mean, reducing overdispersion.}

\item{m}{Mean of the distribution, a positive real number indicating the expected number of successes.
The mean must be positive.}
}
\value{
y The probability of observing up to 'x' successes in a negative binomial distribution
          parameterized by 'r' (dispersion) and 'm' (mean). This function returns the CDF value.
}
\description{
This function calculates the cumulative distribution function (CDF) of the negative binomial distribution
given a number of successes, a dispersion parameter, and the mean. The negative binomial distribution 
is commonly used to model count data with overdispersion relative to a Poisson distribution.
}
\details{
The negative binomial distribution can be parameterized by a dispersion parameter 'r' and a mean 'm',
         which together determine the shape of the distribution. This function is essential for modeling and
         probability calculations in various fields such as epidemiology and ecology where the negative binomial
         distribution is used to model count data.
}
\examples{
pnb(10, 5, 10)
}
