% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{setCustomTime}
\alias{setCustomTime}
\title{Adjust the time of a custom time bar}
\usage{
setCustomTime(id, time, itemId)
}
\arguments{
\item{id}{graph2d id or a \code{linevis} object (the output from \code{linevis()})}

\item{time}{The new date/time}

\item{itemId}{The id of the custom time bar}
}
\value{
None, side-effect is Javascript call
}
\description{
Adjust the time of a custom time bar
}
\examples{
\dontrun{
linevis() \%>\%
  addCustomTime(Sys.Date(), "yesterday") \%>\%
  setCustomTime(Sys.Date() - 1, "yesterday")
}

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    linevisOutput("graph2d"),
    actionButton("btn", "Set time bar 24 hours ago")
  ),
  server = function(input, output) {
    output$graph2d <- renderLinevis(
      linevis() \%>\% addCustomTime(Sys.Date(), "yesterday")
    )
    observeEvent(input$btn, {
      setCustomTime("graph2d", Sys.Date() - 1, "yesterday")
    })
  }
)
}
}
