% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{setGroups}
\alias{setGroups}
\title{Set the groups of a graph2d}
\usage{
setGroups(id, data)
}
\arguments{
\item{id}{graph2d id or a \code{linevis} object (the output from \code{linevis()})}

\item{data}{A dataframe containing the groups data to use.}
}
\value{
None, side-effect is Javascript call
}
\description{
Set the groups of a graph2d
}
\examples{
\dontrun{
linevis(data = data.frame(
  start = c(Sys.Date(), Sys.Date(), Sys.Date() + 1, Sys.Date() + 2),
  content = c("one", "two", "three", "four"),
  group = c(1, 2, 1, 2)),
  groups = data.frame(id = 1:2, content = c("G1", "G2"))
) \%>\%
  setGroups(data.frame(id = 1:2, content = c("Group 1", "Group 2")))
}

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    linevisOutput("graph2d"),
    actionButton("btn", "Change group names")
  ),
  server = function(input, output) {
    output$graph2d <- renderLinevis(
      linevis(data = data.frame(
               start = c(Sys.Date(), Sys.Date(), Sys.Date() + 1, Sys.Date() + 2),
                         content = c("one", "two", "three", "four"),
                         group = c(1, 2, 1, 2)),
              groups = data.frame(id = 1:2, content = c("G1", "G2")))

    )
    observeEvent(input$btn, {
      setGroups("graph2d",
               data.frame(id = 1:2, content = c("Group 1", "Group 2")))
    })
  }
)
}
}
