% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.lspace.R
\name{download.lspace}
\alias{download.lspace}
\title{Download Latent Semantic Spaces}
\usage{
download.lspace(space = "100k_lsa", decompress = TRUE, check.md5 = TRUE,
  mode = "wb", dir = getOption("lingmatch.lspace.dir"),
  overwrite = FALSE)
}
\arguments{
\item{space}{Name of one or more spaces you want to download, or \code{'all'} for all available.
\code{'100k_lsa'} is the default, and some other common options might be \code{'google'}, \code{'facebook'},
or \code{'glove'}. See \href{https://osf.io/489he/wiki/home}{osf.io/489he/wiki} for more information,
and a full list of spaces.}

\item{decompress}{Logical; if \code{TRUE} (default), decompresses the downloaded file
with the \code{bunzip2} system command assuming it is available \cr (as indicated by
\code{Sys.which('bunzip2')}).}

\item{check.md5}{Logical; if \code{TRUE} (default), retrieves the MD5 checksum from OSF,
and compares it with that calculated from the downloaded file to check its integrity.}

\item{mode}{A character specifying the file write mode; default is 'wb'. See
\code{\link{download.file}}.}

\item{dir}{Directory in which to save the space. Specify this here, or set the lspace directory option
(e.g., \code{options(lingmatch.lspace.dir = '~/Latent Semantic Spaces')}), or use
\code{\link{lma_initdirs}} to initialize a directory.}

\item{overwrite}{Logical; if \code{TRUE}, will replace existing files.}
}
\value{
A character vector with paths to the [1] data and [2] term files.
}
\description{
Downloads the specified semantic space from \href{https://osf.io/489he}{osf.io/489he}.
}
\examples{
\dontrun{

download.lspace("glove_crawl", dir = "~/Latent Semantic Spaces")
}
}
\seealso{
Other Latent Semantic Space functions: 
\code{\link{lma_lspace}()},
\code{\link{select.lspace}()},
\code{\link{standardize.lspace}()}
}
\concept{Latent Semantic Space functions}
