% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalizedMI.R
\name{NormalizedMI}
\alias{NormalizedMI}
\title{Maximal Normalized Mutual Information (MaxNMI) function for 2 categorical variables}
\usage{
NormalizedMI(x, y, includeNA = T)
}
\arguments{
\item{x}{a vector of factor.}

\item{y}{a vector of factor.}

\item{includeNA}{a boolean. TRUE to include NA value as a factor level.}
}
\value{
a double between 0 and 1 corresponding to the MaxNMI.
}
\description{
Calculate the MaxNMI relationship measurement for 2 categorical variables
}
\examples{
# calculate a correlation dataframe
data(iris)
discreteSepalLength=BeEFdiscretization.numfact(continuousY=iris$Sepal.Length,factorX=iris$Species)
NormalizedMI(iris$Species,discreteSepalLength)

}
