% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiBivariateCorrelation.R
\name{multiBivariateCorrelation}
\alias{multiBivariateCorrelation}
\title{Calculation of all the bivariate correlations in a dataframe}
\usage{
multiBivariateCorrelation(
  dataset,
  targetVar = NULL,
  corMethods = c("pearson", "spearman", "kendall", "mic", "MaxNMI"),
  maxNbBins = 100,
  showProgress = T
)
}
\arguments{
\item{dataset}{the dataframe which variables bivariate correlations are to be analyzed.}

\item{targetVar}{a vector of character strings corresponding to the names of the target variables. If not NULL, correlation coefficients are computed only with that target variables.}

\item{corMethods}{a vector of correlation coefficients to compute. The available coefficients are the following : \code{c("pearson","spearman","kendall","mic","distCor","MaxNMI")}. It is not case sensitive and still work if only the beginning of the word is put (e.g. \code{pears}).}

\item{maxNbBins}{an integer used if corMethods include 'MaxNMI'. It corresponds to the number of bins limitation (for computation time limitation), maxNbBins=100 by default.}

\item{showProgress}{a boolean to decide whether to show the progress bar.}
}
\value{
a specific dataframe containing correlations values or each specified correlation coefficient.
}
\description{
Computation of a correlation dataframe.
}
\examples{
# run linkspotter on iris example data
data(iris)
corDF<-multiBivariateCorrelation(iris)
print(corDF)

}
