% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_F_test_with_limma.R
\name{compute_F_test_with_limma}
\alias{compute_F_test_with_limma}
\title{Compute an F-test for a multi-level factor independent variable}
\usage{
compute_F_test_with_limma(x, p.adj.threshold = 0.05, print.table = FALSE)
}
\arguments{
\item{x}{(Required) list of models for which the test will be done.
The F-test will be computed for the first independent variable that was
specified in the \code{independent.variables} argument to the
function \code{\link{compute_models_with_limma}}.}

\item{p.adj.threshold}{(Optional) numeric value specifying the threshold
for statistical significance of difference after correction for multiple
testing.}

\item{print.table}{(Optional) \code{TRUE} or \code{FALSE}: Print the results
of the test?}
}
\value{
List \code{x} supplemented by the results of the F-test.
}
\description{
Use this to achieve analysis of variance (ANOVA) or analysis of covariance
   (ANCOVA). The F-test is based on a model produced by the function
   \code{\link{compute_models_with_limma}}.
   To use this function, first call the function
   \code{\link{compute_models_with_limma}}.
}
\seealso{
\code{\link{compute_models_with_limma}} for the model computation
   step that is required prior to calling this function.

\code{\link{compute_post_hoc_test_with_limma}} for the pairwise
   post-hoc comparisons that may follow the F-test done with this function.
}
