## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(listr)

## -----------------------------------------------------------------------------
by_cyl <- split(mtcars, mtcars$cyl)

## -----------------------------------------------------------------------------
by_cyl <- by_cyl |>
  list_rename("cyl4" = `4`, "cyl6" = `6`, "cyl8" = `8`)

## -----------------------------------------------------------------------------
by_cyl |> list_select(cyl6)

## -----------------------------------------------------------------------------
by_cyl |> list_select(1, 2)

## -----------------------------------------------------------------------------
cyl4 <- by_cyl |> list_extract(cyl4)
cyl4

## -----------------------------------------------------------------------------
by_cyl <- by_cyl |> list_remove(cyl4)
by_cyl

## -----------------------------------------------------------------------------
by_cyl <- by_cyl |> list_prepend(cyl4, name = "cyl4")
by_cyl

## -----------------------------------------------------------------------------
by_cyl |>
  list_name_to_df() |>
  list_select(1)

## -----------------------------------------------------------------------------
by_cyl |>
  list_bind(cyl4, cyl6, what = "rows", name = "cyl4_and_6")

## -----------------------------------------------------------------------------
foo <- list(
  1,
  list(1, 2, 3,
       list(4, 5, 6),
       list(7, 8, 9,
            list(10, 11,
                 list(12))),
       13, 14),
  15
)

foo |> list_flatten()

## -----------------------------------------------------------------------------
foo |> list_flatten(max_depth = 1)

