% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_filter.R
\name{list_filter}
\alias{list_filter}
\title{Filter a list.}
\usage{
list_filter(in_list, filter_fun)
}
\arguments{
\item{in_list}{The list to filter.}

\item{filter_fun}{The function to use for filtering.}
}
\value{
A list, `in_list` but filtered according to `filter_fun.`
}
\description{
Filter a list.
}
\details{
`filter_fun` must evaluate to TRUE or FALSE for filtering, where
elements returning TRUE are kept.
}
\examples{
my_list <- list(aa = 1:3, bb =  1:4, cc = 2:5)
list_filter(my_list, function(x) min(x) == 1)
list_filter(my_list, function(x) max(x) > 3)
}
