% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmw_est_aipw.R, R/summary.lmw_est.R
\name{summary.lmw_est_aipw}
\alias{summary.lmw_est_aipw}
\alias{summary.lmw_est}
\title{Extract effect estimates and standard errors from \code{lmw_est} fits}
\usage{
\method{summary}{lmw_est_aipw}(object, model = FALSE, ci = TRUE, alpha = 0.05, ...)

\method{summary}{lmw_est}(object, model = FALSE, ci = TRUE, alpha = 0.05, ...)
}
\arguments{
\item{object}{an \code{lmw_est} object; the output of a call to
\code{lmw_est}.}

\item{model}{\code{logical}; whether to produce a coefficient table for the
outcome model coefficients. Note that these values should not be interpreted
or reported so they are not produced by default.}

\item{ci}{\code{logical}; whether to include confidence intervals in the
output.}

\item{alpha}{when \code{ci = TRUE}, the alpha value used to compute the
critical test statistic for the confidence interval; equivalently, 1 minus
the confidence level (e.g., for a 99\% confidence interval, \code{alpha = .01} should be specified). Default is .05 for a 95\% confidence interval.}

\item{\dots}{ignored.}
}
\value{
A \code{summary.lmw_est} object with the following components:
\item{call}{the original call to \code{lmw_est()}}
\item{means}{a matrix
containing the estimated potential outcome means, their standard errors,
confidence interval limits (if requested with \code{ci = TRUE}),
t-statistics, and p-values. Omitted when \code{method = "URI"} or
\code{fixef} is not \code{NULL} and for \code{lmw_iv} objects.}
\item{coefficients}{a matrix containing the treatment effect estimates and
their standard errors, t-statistics, and p-values.When \code{ci = TRUE}, the
confidence limits \verb{"95\%" CI L} (lower) and \verb{"95\%" CI U} (upper)
will be included between the standard error and t-statistic columns. When
AIPW is used, z-statistics and z-tests are reported instead.}
\item{model.coefficients}{when \code{model = TRUE}, the coefficient table of
the model coefficients, which has the same columns as \code{coefficients.}}
\item{aliased}{when \code{model = TRUE}, a named logical vector showing if
the original coefficients are aliased (i.e., \code{NA}).}
\item{sigma, df, r.squared, adj.r.squared}{the residual standard deviation, degrees of
freedom components, R-squared, and adjusted R-squared. See
\code{\link[=summary.lm]{summary.lm()}}. When AIPW is used, \code{sigma} and \code{df} are
omitted.}

Other components containing information for printing are also included.
}
\description{
\code{summary()} computes the treatment effect and potential outcome mean
estimates from the supplied \code{lmw_est} object. It functions similarly to
\code{\link[=summary.lm]{summary.lm()}} in producing estimate tables with the estimates,
standard errors, t-statistics, and p-values. Other model statistics can be
additionally requested.
}
\details{
\code{summary.lmw_est()} produces a table of treatment effect estimates
corresponding to all possible pairwise contrasts between the treatment
levels. These treatment effects generalize to the population implied by the
regression weights, which depends on the supplied estimand, whether sampling
weights were provided, and which of the MRI or URI models was requested. The
treatment effects are computed using linear contrasts of the outcome model
coefficients.

When \code{method = "MRI"}, the potential outcome mean estimates are also
reported. These correspond to the potential outcome means in the population
implied by the regression weights. When \code{method = "URI"}, only the
treatment effects are estimated; the model-implied outcome means do not
correspond to the potential outcome means for the population implied by the
regression weights. That is, while the treatment effect generalizes to the
population defined by the regression weights, the estimated potential
outcome means do not and so are not reported.

When \code{model = TRUE}, the model coefficients and their tests statistics
are additionally produced. It is inappropriate to interpret or report these
values as they have no causal interpretation. This is especially true when
using AIPW, as the model coefficients do not incorporate the augmentation
terms.
}
\examples{
# See examples at `help("lmw_est")`
}
\seealso{
\code{\link[=lmw_est]{lmw_est()}} for fitting the outcome regression model,
\code{\link[=summary.lm]{summary.lm()}} for more information on the output components
}
