% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fit_on_data.R
\name{plot_fit_on_data}
\alias{plot_fit_on_data}
\title{Function used to quick visualize the fitted values (survival estimate) on the data used to fit the model (via EM algorithm or Gibbs).}
\usage{
plot_fit_on_data(
  model,
  data,
  type = "survival",
  interval = "none",
  level = 0.95
)
}
\arguments{
\item{model}{A \code{survival_ln_mixture} or \code{survival_ln_mixture_em} object.}

\item{data}{A \code{data.frame()} or \code{tibble()} containing the data used to fit the model. For appropriate behavior, should be the same object used to generate survival_ln_mixture/survival_ln_mixture_em objects.}

\item{type}{A character string specifying the type of plot. The default is "survival", but can be "hazard".}

\item{interval}{A character string specifying the type of interval to be plotted. The default is "none", but can be "credible". The EM algorithm does not provide confidence intervals and this parameter is only support for the Bayesian version (\code{survival_ln_mixture} object).}

\item{level}{A numeric value between 0 and 1 specifying the level of the confidence interval. The default is 0.95.}
}
\value{
A list with two objects, one ggplot (\verb{$ggplot}) with the predictions plotted against the empirical data and a tibble with the predictions (\verb{$preds}).
}
\description{
\code{plot_fit_on_data()} estimates survival/hazard for the data the model was fitted on and plots the results.
}
