\name{5.1.plot.interactives}
\alias{5.1.plot.interactives}
\alias{getXY}
\alias{getLatLon}
\alias{screenLatticePlot}

\title{
  Interactive plot functions
}
\description{
  Recovering information from existing lattice plots.
}
\usage{

getXY(n = -1, ..., unit = "native", scale.correction = NULL)

getLatLon(...,   
          scale.correction = function(x) {
                                temp <- MercatorXY2LatLon(x$x, x$y)
                                as.list(as.data.frame(temp))
                            })

}

\arguments{

  \item{n}{ If positive, the maximum number of points to locate. If negative 
   (default), unlimited. 
  } 

  \item{unit}{ The unit to use when reporting located points, by 
   default \code{"native"}.
  } 

  \item{scale.correction}{ The correction to apply if the plot has 
   locally scaled axes. See Note below.  
  } 

  \item{...}{ Additional arguments, passed on to related functions.

   These may be subject to revision, but are currently: 
   \code{\link[lattice]{trellis.focus}} for panel selection (if working with multi-panel 
   plots) and \code{\link[lattice]{lpoints}} to set point properties (if marking selected 
   points). For \code{getLatLon}, additional arguments are also passed to 
   \code{\link[RgoogleMaps]{XY2LatLon}} for x, y to latitude, longitude rescaling.
 
  } 

}


\details{
  \code{getXY} is an interactive function which returns 
  the locations of points on a plot selected using the 
  mouse (left click to select points; right click and 
  stop to end point collection; escape to abort without 
  returning any values). 

  It is a wrapper for the \code{grid} function 
   \code{\link[grid]{grid.locator}} that behaves more like 
   \code{\link[graphics]{locator}}, the equivalent function intended 
   for use with \code{\link{plot}} outputs. 

  By default \code{getXY} selections are not automatically 
   marked. Adding common plot parameters to the function 
   call overrides this behaviour, e.g. to add red symbols 
   and lines.  
   
   \code{ans <- getXY(col = "red", pch = 4, type = "b")} 
   
  \code{getXY} also provides a mechanism to handle data plotted on 
   locally scaled axes. See Note below.

  \code{getLatLon} is wrapper for \code{getXY} for use 
   with \code{loaMapPlot} and other similarly 
   georeferenced plots. See Note below.
     
}

\value{
  \code{getXY} returns the x and y coordinates of 
   the selected points on a plot as a list containing two 
   components, \code{x} and \code{y}.

  \code{getLatLon} returns the latitude and longitude 
   values of the selected points on a map as a list 
   containing two components, \code{lat} and \code{lon}.
  
}

\note{

  \code{getXY} recovers the (x, y) coordinates of points selected 
  on a previously generated plot.

  Some plots, use local scaling. For example, when plotting 
  latitude, longitude data on a map a scale correction may be 
  used to account for the curvature of the Earth. Similarly, if 
  different data series are plotted on primary and secondary axes 
  in a single plot, some or all data may be normalised. In such 
  cases scaling may be local, i.e. what you actually plot may not be 
  exactly what the annotation says it is. 

  Using \code{getXY} on such plots would recover the actual (x, y) 
  coordinates of the points selected.      

  However, corrections can be applied using \code{scale.correction}, 
  if it is supplied, to convert these to the same scale as the axes 
  annotation. The correction should be a function that can be 
  applied directly to a standard \code{getXY} output (a list of 
  \code{x} and \code{y} values) and rescale x and y to give 
  their 'corrected' values.

  \code{getLatLon} provides an example of the mechanism, and is 
  for use with georeferenced plots that have been locally scaled 
  using \code{\link{LatLon2MercatorXY}}. \code{getLatLon} uses 
  \code{\link{MercatorXY2LatLon}} to rescale \code{x} and \code{y} 
  values and then \code{as...} functions to convert the outputs of 
  this step to a list format like that generated by \code{locator}, 
  \code{grid.locator} or \code{getXY}.    
}


\references{
  This function makes extensive use of code developed by others.

  lattice:
  Sarkar, Deepayan (2008) Lattice: Multivariate Data
  Visualization with R. Springer, New York. ISBN
  978-0-387-75968-5

  RgoogleMaps:
  Markus Loecher and Sense Networks (2011).
  RgoogleMaps: Overlays on Google map tiles in R. R
  package version 1.1.9.6.
  http://CRAN.R-project.org/package=RgoogleMaps
}

\author{
  Karl Ropkins
}

\seealso{
   In other packages: See \code{\link[grid]{grid.locator}}; 
   \code{\link[lattice]{trellis.focus}} and \code{\link[lattice]{lpoints}} in \code{\link[lattice]{lattice}}.    
}


%\examples{
%##
%##to be confirmed
%##getXY on xyplot
%##example 2
%##Move getLatLon code to examples
%}


\keyword{ methods }
