% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisp.R
\name{lisp}
\alias{lisp}
\title{local indicator of stratified power}
\usage{
lisp(
  formula,
  data,
  threshold,
  distmat,
  discvar = NULL,
  discnum = 3:8,
  discmethod = c("sd", "equal", "geometric", "quantile", "natural"),
  cores = 1,
  ...
)
}
\arguments{
\item{formula}{A formula.}

\item{data}{The observation data.}

\item{threshold}{The distance threshold employed to select "local" data.}

\item{distmat}{The distance matrices.}

\item{discvar}{(optional) Name of continuous variable columns that need to be discretized. Noted
that when \code{formula} has \code{discvar}, \code{data} must have these columns. By default, all independent
variables are used as \code{discvar}.}

\item{discnum}{(optional) A vector of number of classes for discretization. Default is \code{3:8}.}

\item{discmethod}{(optional) A vector of methods for discretization, default is using
\code{c("sd","equal","geometric","quantile","natural")} by invoking \code{sdsfun}.}

\item{cores}{(optional) Positive integer (default is 1). When cores are greater than 1, use
multi-core parallel computing.}

\item{...}{(optional) Other arguments passed to \code{gdverse::gd_optunidisc()}. A useful parameter
is \code{seed}, which is used to set the random number seed.}
}
\value{
A \code{tibble}.
}
\description{
local indicator of stratified power
}
\examples{
gtc = readr::read_csv(system.file("extdata/gtc.csv", package = "localsp"))
gtc

\donttest{
# Sample 100 observations from the original data to save runtime;
# This is unnecessary in practice;
set.seed(42)
gtc1 = gtc[sample.int(nrow(gtc),size = 100),]
distmat = as.matrix(dist(gtc1[, c("X","Y")]))
gtc1 = gtc1[, -c(1,2)]
gtc1

# Use 2 cores for parallel computing;
# Increase cores in practice to speed up;
lisp(GTC ~ ., data = gtc1, threshold = 4.2349, distmat = distmat,
     discnum = 3:5, discmethod = "quantile", cores = 2)
}
}
