% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate.R
\name{locate_ip}
\alias{locate_ip}
\title{Locate an IP adress}
\usage{
locate_ip(
  ip = NULL,
  fields = c("status,message,country,city"),
  lang = "en",
  ...,
  tidy = TRUE
)
}
\arguments{
\item{ip}{String. Either an IPv4 address, IPv6 address or a domain name. If NULL, will use the current IP address.}

\item{fields}{String. Response fields to pass on to the API.}

\item{lang}{String. Response language. An ISO 639 code supported by the API. Defaults to English.}

\item{...}{Query parameters to pass on to the API.}

\item{tidy}{Logical. TRUE to return a tibble. FALSE to return a string.}
}
\value{
A string or a tibble.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
For API documentation and terms of service, see \href{https://ip-api.com/}{ip-api.com}.
}
\examples{
locate_ip("132.203.167.188")
}
