% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.logitr}
\alias{predict.logitr}
\title{Predict probabilities and / or outcomes}
\usage{
\method{predict}{logitr}(
  object,
  newdata = NULL,
  obsID = NULL,
  type = "prob",
  returnData = FALSE,
  interval = "none",
  level = 0.95,
  numDrawsCI = 10^4,
  pars = NULL,
  scalePar = NULL,
  randPars = NULL,
  randScale = NULL,
  ci,
  ...
)
}
\arguments{
\item{object}{is an object of class \code{logitr} (a model estimated using
the 'logitr()` function).}

\item{newdata}{a \code{data.frame}. Each row is an alternative and each column an
attribute corresponding to parameter names in the estimated model. Defaults
to \code{NULL}, in which case predictions are made on the original data used to
estimate the model.}

\item{obsID}{The name of the column that identifies each set of
alternatives in the data. Required if newdata != NULL. Defaults to \code{NULL},
in which case the value for \code{obsID} from the data in \code{object} is used.}

\item{type}{A character vector defining what to predict: \code{prob} for
probabilities, \code{outcomes} for outcomes. If you want both outputs, use
\code{c("prob", "outcome")}. Outcomes are predicted randomly according to the
predicted probabilities. Defaults to \code{"prob"}.}

\item{returnData}{If \code{TRUE} the data is also returned, otherwise only the
predicted values ("prob" and / or  "outcome") are returned.
Defaults to \code{FALSE}.}

\item{interval}{Type of interval calculation: "none" (default) or
"confidence". Future versions will include "prediction" intervals as well.}

\item{level}{Tolerance / confidence interval. Defaults to 0.95.}

\item{numDrawsCI}{The number of draws to use in simulating uncertainty
for the computed CI. Defaults to 10^4.}

\item{pars}{The names of the parameters to be estimated in the model.
Must be the same as the column names in the \code{data} argument. For WTP space
models, do not include the \code{scalePar} variable in \code{pars}.}

\item{scalePar}{The name of the column that identifies the scale variable,
which is typically "price" for WTP space models, but could be any
continuous variable, such as "time". Defaults to \code{NULL}.}

\item{randPars}{A named vector whose names are the random parameters and
values the distribution: \code{'n'} for normal, \code{'ln'} for log-normal, or
\code{'cn'} for zero-censored normal. Defaults to \code{NULL}.}

\item{randScale}{The random distribution for the scale parameter: \code{'n'} for
normal, \code{'ln'} for log-normal, or \code{'cn'} for zero-censored normal. Only used
for WTP space MXL models. Defaults to \code{NULL}.}

\item{ci}{No longer used as of v1.1.0 - if provided, this is passed
to the \code{level} argument, \code{interval} is set to \code{"confidence"},
and a warning is displayed.}

\item{...}{further arguments.}
}
\value{
A data frame of predicted probabilities and / or outcomes.
}
\description{
This method is used for computing predicted probabilities and / or outcomes
for either the data used for model estimation or a new data set consisting
of a single or multiple sets of alternatives.
}
\examples{
library(logitr)

# Estimate a preference space model
mnl_pref <- logitr(
  data    = yogurt,
  outcome = "choice",
  obsID   = "obsID",
  pars    = c("price", "feat", "brand")
)

# Predict probabilities and / or outcomes

# Predict probabilities for each alternative in the model data
probs <- predict(mnl_pref)
head(probs)

# Create a set of alternatives for which to make predictions.
# Each row is an alternative and each column an attribute.
data <- subset(
    yogurt, obsID \%in\% c(42, 13),
    select = c('obsID', 'alt', 'price', 'feat', 'brand'))
data

# Predict probabilities using the estimated model
predict(mnl_pref, newdata = data, obsID = "obsID")

# Predict probabilities and include a 95\% confidence interval
predict(
  mnl_pref,
  newdata = data,
  obsID = "obsID",
  interval = "confidence",
  level = 0.95
)

# Predict outcomes
predict(mnl_pref, newdata = data, obsID = "obsID", type = "outcome")

# Predict outcomes and probabilities
predict(mnl_pref, newdata = data, obsID = "obsID", type = c("prob", "outcome"))
}
\keyword{logitr}
\keyword{predict}
\keyword{probabilities}
