% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lognorm.R
\name{scaleLogToOrig}
\alias{scaleLogToOrig}
\alias{scaleOrigToLog}
\title{Scale standard deviation between log and original scale.}
\usage{
scaleLogToOrig(logmean, sigma)

scaleOrigToLog(mean, sd)
}
\arguments{
\item{logmean}{log of the expected value}

\item{sigma}{standard deviation at log scale}

\item{mean}{expected value at original scale}

\item{sd}{standard deviation at original scale}
}
\value{
numeric matrix with columns \code{mean}, and \code{sd} at original scale
}
\description{
When comparing values at log scale that have different sd at original scale, 
better compare log(mean) instead of mu.
}
\section{Functions}{
\itemize{
\item \code{scaleLogToOrig}: get logmean and sigma at log scale

\item \code{scaleOrigToLog}: get mean and sd at original scale
}}

\examples{
  xLog <- data.frame(logmean = c(0.8, 0.8), sigma = c(0.2, 0.3))
  xOrig <- as.data.frame(scaleLogToOrig(xLog$logmean, xLog$sigma))
  xLog2 <- as.data.frame(scaleOrigToLog(xOrig$mean, xOrig$sd))
  all.equal(xLog, xLog2)
  xLog3 <- as.data.frame(getParmsLognormForMoments(xOrig$mean, xOrig$sd^2))
  all.equal(xLog$sigma, xLog3$sigma) # but mu  < logmean 
}
