% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R, R/threshstab.R
\name{autoplot.elife_tstab}
\alias{autoplot.elife_tstab}
\alias{plot.elife_tstab}
\title{Threshold stability plots}
\usage{
autoplot.elife_tstab(object, ...)

\method{plot}{elife_tstab}(
  x,
  plot.type = c("base", "ggplot"),
  which.plot = c("scale", "shape"),
  plot = TRUE,
  ...
)
}
\arguments{
\item{object}{object of class \code{elife_tstab}, representing parameter estimates to draw threshold stability plots}

\item{...}{additional arguments, currently ignored by the function.}

\item{x}{an object of class \code{elife_tstab} containing
the fitted parameters as a function of threshold}

\item{plot.type}{string, one of \code{base} for base R or \code{ggplot}}

\item{which.plot}{vector of string indicating the plots, among \code{pp} for probability-probability plot, \code{qq} for quantile-quantile plot, \code{erp} for empirically rescaled plot (only for censored data), \code{exp} for standard exponential quantile-quantile plot or \code{tmd} for Tukey's mean difference plot, which is a variant of the Q-Q plot in which we map the pair \eqn{(x,y)} is mapped to \code{((x+y)/2,y-x)} are detrended, \code{dens} and \code{cdf} return the empirical distribution function with the fitted parametric density or distribution function curve superimposed.}

\item{plot}{logical; if \code{TRUE}, creates a plot when \code{plot.type="ggplot"}. Useful for returning \code{ggplot} objects without printing the graphs}
}
\description{
Threshold stability plots
}
