% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FPCA_trajectory.R
\name{FPCA_trajectory}
\alias{FPCA_trajectory}
\title{FPCA_trajectory}
\usage{
FPCA_trajectory(data,...)
}
\arguments{
\item{data}{A long format data matrix containing 3 columns ordered by
time, subject ID, variable where the measurement time of
the longitudinal data should be discretized}

\item{...}{Arguments to be passed to fdapace::FPCA}
}
\value{
A list containing two elements
\item{fpca_target}{A FPCA object}
\item{target_fit}{A num.t x num.sub matrix containing the imputated longitudinal trajectories
                   where num.t is the total number of the discrete measurement time and
                   num.sub is the total number of subjects}
}
\description{
Function used to perform functional principal component analysis (FPCA)
               for a single functional variable
}
\examples{
t_all = 1:50
data = datagen(ntotal=350,ntest=50,t_all=t_all,t_split=25,seed=1)
data.sample = data$test[,c(1,2,3)]
# In this case, num.t=50 and num.sub=50 since we only used 50 subjects in the testing data
data.FPCA = FPCA_trajectory(data.sample,list(dataType='Sparse',
                error=FALSE, kernel='gauss', verbose=FALSE, nRegGrid=length(t_all)))
data.FPCA$target_fit

}
\references{
\cite{Carroll, C., Gajardo, A., Chen, Y., Dai, X., Fan, J., Hadjipantelis, P. Z., ... & Wang, J. L. (2020).
fdapace: Functional data analysis and empirical dynamics. R package version 0.5, 4.}

\cite{Yao, F., Müller, H. G., & Wang, J. L. (2005).
Functional data analysis for sparse longitudinal data. Journal of the American statistical association, 100(470), 577-590.}
}
