% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mnRateRatioCI}
\alias{mnRateRatioCI}
\title{Miettinen-Nurminen Score Confidence Interval for
Two-Sample Rate Ratio}
\usage{
mnRateRatioCI(t1, y1, t2, y2, cilevel = 0.95)
}
\arguments{
\item{t1}{The exposure for the active treatment group.}

\item{y1}{The number of events for the active treatment group.}

\item{t2}{The exposure for the control group.}

\item{y2}{The number of events for the control group.}

\item{cilevel}{The confidence interval level.}
}
\value{
A list with two components:
\itemize{
\item \code{data} A data frame containing the input exposure
and number of events for each treatment group.
It has the following variables:
\itemize{
\item \code{t1}: The exposure for the active treatment group.
\item \code{y1}: The number of events for the active treatment group.
\item \code{t2}: The exposure for the control group.
\item \code{y2}: The number of events for the control group.
}
\item \code{estimates}: A data frame containing the point estimate
and confidence interval for rate ratio. It has the following
variables:
\itemize{
\item \code{scale}: The scale of treatment effect.
\item \code{estimate}: The point estimate.
\item \code{lower}: The lower limit of the confidence interval.
\item \code{upper}: The upper limit of the confidence interval.
\item \code{cilevel}: The confidence interval level.
}
}
}
\description{
Obtains the Miettinen-Nurminen score confidence
interval for two-sample rate ratio possibly with
stratification.
}
\details{
The Mantel-Haenszel weights are used for stratified samples.
}
\examples{

mnRateRatioCI(t1 = c(10,10), y1 = c(4,3), t2 = c(20,10), y2 = c(2,0))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
