% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_fun.R
\name{hdrbs}
\alias{hdrbs}
\title{Calculate the optiaml bandwidth matrix for highest density region
estimation}
\usage{
hdrbs(X, tau, xrange, yrange, gridwidth, init = NULL, maxit = 200,
  tol = 1e-06, print_obj = FALSE)
}
\arguments{
\item{X}{a matrix with two columns containing the data from the
density function.}

\item{tau}{a probability value between 0 and 1}

\item{xrange}{a vector of of length 2, e.g., \code{c(xmin, xmax)},
indicating the range the grid points to be generated on x-axis}

\item{yrange}{a vector of of length 2, e.g., \code{c(ymin, ymax)},
indicating the range the grid points to be generated on y-axis}

\item{gridwidth}{width between grid points.}

\item{init}{starting value of the bandwidth matrix for
optimization. If not specified, use direct-plug estimator from
\code{ks} package as starting value}

\item{maxit}{maximum number of iterations for optimization}

\item{tol}{tolerance value for stopping the optimization algorithm}

\item{print_obj}{a flag (boolean type) indicates printing the loss
function values during optimizatin or not.}
}
\value{
the optimal bandwidth matrix.
}
\description{
This function allow you to compute the optiaml bandwidth matrix
for highest density region estimation by using a plug-in strategy.
}
\examples{
X <- matrix(rnorm(100),ncol=2)
xrange <- c(-2.5,2.5)
yrange <- c(-2.5,2.5)
hdrbs(X,0.1,xrange,yrange,0.1)

}
\references{
Doss, C.R. and Weng, G., 2018. \emph{Bandwidth selection for
kernel density estimators of multivariate level sets and highest
density regions}. arXiv preprint arXiv:1806.00731.
}
