% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-ThreeMapComparison.R
\docType{class}
\name{ThreeMapComparison-class}
\alias{ThreeMapComparison-class}
\title{Class ThreeMapComparison}
\description{
An S4 class to hold results of a comparison between a reference map for time
1, a reference map for time 2 and a simulation map for time 2 using the
the method described by Pontius et al. (2011).
}
\section{Slots}{

\describe{
\item{\code{tables}}{list of data.frames that depict the three dimensional table
described by Pontius et al. (2011) at different resolutions}

\item{\code{factors}}{numeric vector of aggregation factors}

\item{\code{maps}}{list of RasterStack objects containing land use maps at different
resolutions}

\item{\code{categories}}{numeric vector of land use categories}

\item{\code{labels}}{character vector corresponding to \code{categories}}
}}

\references{
Pontius Jr, R.G., Peethambaram, S., Castella, J.C. (2011).
Comparison of three maps at multiple resol utions: a case study of land change
simulation in Cho Don District, Vietnam. Annals of the Association of American
Geographers 101(1): 45-62.
}
